/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Circuit {
    protected Hashtable m_map = new Hashtable();

    public void addNode(String name) {
        if (this.m_map.get(name) == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            this.m_map.put(name, circuit.new Node(name));
        }
    }

    public void removeNode(String name) {
        String tmp = null;
        Enumeration e = this.m_map.keys();
        while (e.hasMoreElements()) {
            tmp = (String)e.nextElement();
            if (tmp.equals(name)) continue;
            try {
                this.unlink(tmp, name);
            }
            catch (CircuitException ce) {
                // empty catch block
            }
            try {
                this.unlink(name, tmp);
            }
            catch (CircuitException ce) {
                // empty catch block
            }
        }
        this.m_map.remove(name);
    }

    public void link(String parent, String child) throws CircuitException {
        Node tempNode = null;
        Node pnode = (Node)this.m_map.get(parent);
        Node cnode = (Node)this.m_map.get(child);
        if (pnode == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + parent);
        }
        if (cnode == null) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Unknown node " + child);
        }
        if (pnode.isChildOf(cnode)) {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Loop! Node " + parent + " is already child of node " + child);
        }
        Enumeration e = this.m_map.elements();
        while (e.hasMoreElements()) {
            tempNode = (Node)e.nextElement();
            if (!tempNode.isChildOf(cnode)) continue;
            tempNode.m_parents.addAll(pnode.m_parents);
        }
    }

    public void unlink(String parent, String child) throws CircuitException {
        Node cnode = (Node)this.m_map.get(child);
        Node pnode = (Node)this.m_map.get(parent);
        if (cnode.m_parents.contains(pnode)) {
            Node tempNode = null;
            Enumeration e = this.m_map.elements();
            while (e.hasMoreElements()) {
                tempNode = (Node)e.nextElement();
                if (!tempNode.m_parents.contains(cnode)) continue;
                tempNode.m_parents.removeAll(pnode.m_parents);
            }
        } else {
            Circuit circuit = this;
            if (circuit == null) {
                throw null;
            }
            throw circuit.new CircuitException("Node " + parent + " is not parent of node " + child);
        }
    }

    public Vector getAncestors() {
        Vector<String> ancestors = new Vector<String>();
        String name = null;
        Node tempNode = null;
        Enumeration e = this.m_map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.m_map.get(name);
            if (1 != tempNode.m_parents.size()) continue;
            ancestors.addElement(name);
        }
        return ancestors;
    }

    public String getAncestor() {
        String name = null;
        Node tempNode = null;
        Enumeration e = this.m_map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.m_map.get(name);
            if (1 != tempNode.m_parents.size()) continue;
            return name;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String name = null;
        Node tempNode = null;
        Enumeration e = this.m_map.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            tempNode = (Node)this.m_map.get(name);
            buffer.append(name + "(" + (tempNode.m_parents.size() - 1) + ") ");
        }
        return buffer.toString();
    }

    protected final class Node {
        protected Vector m_parents = new Vector(5);
        protected String m_name;

        protected boolean isChildOf(Node parent) {
            return this.m_parents.contains(parent);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Enumeration e = this.m_parents.elements();
            buffer.append(this.m_name + "[");
            while (e.hasMoreElements()) {
                buffer.append(((Node)e.nextElement()).m_name + " ");
            }
            buffer.append("]");
            return buffer.toString();
        }

        protected Node(String name) {
            this.m_parents.addElement(this);
            this.m_name = name;
        }
    }

    public final class CircuitException
    extends RuntimeException {
        public CircuitException() {
        }

        public CircuitException(String message) {
            super(message);
        }
    }
}

