/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.utils.recycle;

import org.apache.avalon.utils.recycle.Recyclable;
import org.apache.avalon.utils.recycle.RecycleBin;
import org.apache.avalon.utils.recycle.RecycleBinIsFull;

public class LimitedContainer
implements RecycleBin {
    private RecycleBin container;
    private int capacity;

    public Recyclable getRecyclable() {
        return this.container.getRecyclable();
    }

    public void recycle(Recyclable object) {
        if (this.container.getSize() >= this.capacity) {
            try {
                object.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RecycleBinIsFull();
        }
        this.container.recycle(object);
    }

    public int getSize() {
        return this.container.getSize();
    }

    public LimitedContainer(RecycleBin container, int capacity) {
        this.container = container;
        this.capacity = capacity;
    }
}

