/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.test;

import org.apache.avalon.util.BinaryHeap;
import org.apache.testlet.AbstractTestlet;

public final class BinaryHeapTestlet
extends AbstractTestlet {
    protected static final Integer VAL1 = new Integer(1);
    protected static final Integer VAL2 = new Integer(2);
    protected static final Integer VAL3 = new Integer(3);
    protected static final Integer VAL4 = new Integer(4);
    protected static final Integer VAL5 = new Integer(5);
    protected static final Integer VAL6 = new Integer(6);
    protected static final Integer VAL7 = new Integer(7);

    public void testSimpleOrder() {
        BinaryHeap heap = new BinaryHeap();
        heap.clear();
        heap.insert(VAL1);
        heap.insert(VAL2);
        heap.insert(VAL3);
        heap.insert(VAL4);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL4 == heap.pop());
    }

    public void testReverseOrder() {
        BinaryHeap heap = new BinaryHeap();
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL3);
        heap.insert(VAL2);
        heap.insert(VAL1);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL4 == heap.pop());
    }

    public void testMixedOrder() {
        BinaryHeap heap = new BinaryHeap();
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL4 == heap.pop());
    }

    public void testDuplicates() {
        BinaryHeap heap = new BinaryHeap();
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL4 == heap.pop());
    }

    public void testMixedInsertPopOrder() {
        BinaryHeap heap = new BinaryHeap();
        heap.clear();
        heap.insert(VAL1);
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL4 == heap.pop());
        this.assert(VAL4 == heap.pop());
    }

    public void testReverseSimpleOrder() {
        BinaryHeap heap = new BinaryHeap(false);
        heap.clear();
        heap.insert(VAL1);
        heap.insert(VAL2);
        heap.insert(VAL3);
        heap.insert(VAL4);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
    }

    public void testReverseReverseOrder() {
        BinaryHeap heap = new BinaryHeap(false);
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL3);
        heap.insert(VAL2);
        heap.insert(VAL1);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
    }

    public void testReverseMixedOrder() {
        BinaryHeap heap = new BinaryHeap(false);
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
    }

    public void testReverseDuplicates() {
        BinaryHeap heap = new BinaryHeap(false);
        heap.clear();
        heap.insert(VAL4);
        heap.insert(VAL3);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
    }

    public void testReverseMixedInsertPopOrder() {
        BinaryHeap heap = new BinaryHeap(false);
        heap.clear();
        heap.insert(VAL1);
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        heap.insert(VAL4);
        heap.insert(VAL2);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL1);
        heap.insert(VAL3);
        this.assert(VAL4 == heap.pop());
        this.assert(VAL3 == heap.pop());
        this.assert(VAL2 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.peek());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
        this.assert(VAL1 == heap.pop());
    }
}

