/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon;

import java.util.ArrayList;
import org.apache.avalon.Configuration;
import org.apache.avalon.DefaultConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXConfigurationHandler
extends DefaultHandler
implements ErrorHandler {
    protected final ArrayList m_elements = new ArrayList();
    protected Configuration m_configuration;
    protected Locator m_locator;

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        this.m_locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        String value = new String(ch, start, end).trim();
        DefaultConfiguration configuration = (DefaultConfiguration)this.m_elements.get(this.m_elements.size() - 1);
        configuration.appendValueData(value);
    }

    public void endElement(String namespaceURI, String localName, String rawName) {
        int location = this.m_elements.size() - 1;
        Object object = this.m_elements.remove(location);
        if (location == 0) {
            this.m_configuration = (Configuration)object;
        }
    }

    protected DefaultConfiguration createConfiguration(String localName, String location) {
        return new DefaultConfiguration(localName, location);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        DefaultConfiguration configuration = this.createConfiguration(localName, this.getLocationString());
        int size = this.m_elements.size() - 1;
        if (size > -1) {
            DefaultConfiguration parent = (DefaultConfiguration)this.m_elements.get(size);
            parent.addChild(configuration);
        }
        this.m_elements.add(configuration);
        int attributesSize = attributes.getLength();
        int i = 0;
        while (i < attributesSize) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            configuration.addAttribute(name, value);
            ++i;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    protected String getLocationString() {
        if (this.m_locator == null) {
            return "Unknown";
        }
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + ":" + this.m_locator.getColumnNumber();
    }
}

