/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private boolean parallel = false;
    protected String type = "file";

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void checkConfiguration() {
        super.checkConfiguration();
        if (this.filesets.size() == 0) {
            throw new BuildException("no filesets specified", this.location);
        }
    }

    protected void runExec(Execute exe) throws BuildException {
        try {
            try {
                Vector<String> v = new Vector<String>();
                int i = 0;
                while (i < this.filesets.size()) {
                    int j;
                    String[] s;
                    FileSet fs = (FileSet)this.filesets.elementAt(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                    if (!"dir".equals(this.type)) {
                        s = ds.getIncludedFiles();
                        j = 0;
                        while (j < s.length) {
                            v.addElement(new File(fs.getDir(this.project), s[j]).getAbsolutePath());
                            ++j;
                        }
                    }
                    if (!"file".equals(this.type)) {
                        s = ds.getIncludedDirectories();
                        j = 0;
                        while (j < s.length) {
                            v.addElement(new File(fs.getDir(this.project), s[j]).getAbsolutePath());
                            ++j;
                        }
                    }
                    ++i;
                }
                Object[] s = new String[v.size()];
                v.copyInto(s);
                int err = -1;
                String myos = System.getProperty("os.name");
                if (this.parallel) {
                    this.cmdl.addArguments((String[])s);
                    exe.setCommandline(this.cmdl.getCommandline());
                    err = exe.execute();
                    if (err != 0) {
                        if (this.failOnError) {
                            throw new BuildException("Exec returned: " + err, this.location);
                        }
                        this.log("Result: " + err, 0);
                    }
                } else {
                    String[] cmd = new String[this.cmdl.size() + 1];
                    System.arraycopy(this.cmdl.getCommandline(), 0, cmd, 0, this.cmdl.size());
                    int i2 = 0;
                    while (i2 < s.length) {
                        cmd[this.cmdl.size()] = s[i2];
                        exe.setCommandline(cmd);
                        err = exe.execute();
                        if (err != 0) {
                            if (this.failOnError) {
                                throw new BuildException("Exec returned: " + err, this.location);
                            }
                            this.log("Result: " + err, 0);
                        }
                        ++i2;
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException("Execute failed: " + e, e, this.location);
            }
            Object var3_12 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var3_13 = null;
            this.logFlush();
            throw throwable;
        }
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setType(FileDirBoth type) {
        this.type = type.getValue();
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

