/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.cli.test;

import java.util.Vector;
import org.apache.avalon.util.cli.AbstractParserControl;
import org.apache.avalon.util.cli.CLArgsParser;
import org.apache.avalon.util.cli.CLOption;
import org.apache.avalon.util.cli.CLOptionDescriptor;
import org.apache.testlet.AbstractTestlet;

public final class ClutilTestlet
extends AbstractTestlet {
    protected static final String[] ARGLIST1 = new String[]{"--you", "are", "--all", "-cler", "kid"};
    protected static final String[] ARGLIST2 = new String[]{"-Dstupid=idiot", "are", "--all", "here"};
    protected static final String[] ARGLIST3 = new String[]{"-Dstupid=idiot", "are", "--all", "--all", "here"};
    protected static final String[] ARGLIST4 = new String[]{"-Dstupid=idiot", "are", "--all", "--blee", "here"};
    protected static final String[] ARGLIST5 = new String[]{"-f", "myfile.txt"};
    private static final int DEFINE_OPT = 68;
    private static final int YOU_OPT = 121;
    private static final int ALL_OPT = 97;
    private static final int CLEAR1_OPT = 99;
    private static final int CLEAR2_OPT = 108;
    private static final int CLEAR3_OPT = 101;
    private static final int CLEAR5_OPT = 114;
    private static final int BLEE_OPT = 98;
    private static final int FILE_OPT = 102;
    protected static final CLOptionDescriptor DEFINE = new CLOptionDescriptor("define", 16, 68, "define");
    protected static final CLOptionDescriptor YOU = new CLOptionDescriptor("you", 8, 121, "you");
    protected static final CLOptionDescriptor ALL = new CLOptionDescriptor("all", 8, 97, "all", new int[]{98});
    protected static final CLOptionDescriptor CLEAR1 = new CLOptionDescriptor("c", 8, 99, "c");
    protected static final CLOptionDescriptor CLEAR2 = new CLOptionDescriptor("l", 8, 108, "l");
    protected static final CLOptionDescriptor CLEAR3 = new CLOptionDescriptor("e", 8, 101, "e");
    protected static final CLOptionDescriptor CLEAR5 = new CLOptionDescriptor("r", 8, 114, "r");
    protected static final CLOptionDescriptor BLEE = new CLOptionDescriptor("blee", 8, 98, "blee");
    protected static final CLOptionDescriptor FILE = new CLOptionDescriptor("file", 2, 102, "the build file.");

    public void testFullParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 8);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 121);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 0);
        this.assertEquality(((CLOption)clOptions.get(2)).getId(), 97);
        this.assertEquality(((CLOption)clOptions.get(3)).getId(), 99);
        this.assertEquality(((CLOption)clOptions.get(4)).getId(), 108);
        this.assertEquality(((CLOption)clOptions.get(5)).getId(), 101);
        this.assertEquality(((CLOption)clOptions.get(6)).getId(), 114);
        this.assertEquality(((CLOption)clOptions.get(7)).getId(), 0);
    }

    public void testDuplicateOptions() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1};
        CLArgsParser parser = new CLArgsParser(ARGLIST3, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 5);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 68);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 0);
        this.assertEquality(((CLOption)clOptions.get(2)).getId(), 97);
        this.assertEquality(((CLOption)clOptions.get(3)).getId(), 97);
        this.assertEquality(((CLOption)clOptions.get(4)).getId(), 0);
    }

    public void testIncompatableOptions() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1, BLEE};
        CLArgsParser parser = new CLArgsParser(ARGLIST4, options);
        this.assertNotNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 5);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 68);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 0);
        this.assertEquality(((CLOption)clOptions.get(2)).getId(), 97);
        this.assertEquality(((CLOption)clOptions.get(3)).getId(), 98);
        this.assertEquality(((CLOption)clOptions.get(4)).getId(), 0);
    }

    public void testSingleArg() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(ARGLIST5, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 1);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 102);
        this.assertEquality(((CLOption)clOptions.get(0)).getArgument(), "myfile.txt");
    }

    public void test2ArgsParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1};
        CLArgsParser parser = new CLArgsParser(ARGLIST2, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 4);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 68);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 0);
        this.assertEquality(((CLOption)clOptions.get(2)).getId(), 97);
        this.assertEquality(((CLOption)clOptions.get(3)).getId(), 0);
        CLOption option = (CLOption)clOptions.get(0);
        this.assertEquality("stupid", option.getArgument(0));
        this.assertEquality("idiot", option.getArgument(1));
    }

    public void testPartParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU};
        ClutilTestlet clutilTestlet = this;
        if (clutilTestlet == null) {
            throw null;
        }
        AbstractParserControl control = new AbstractParserControl(clutilTestlet){
            private final /* synthetic */ ClutilTestlet this$0;

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 121;
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(ClutilTestlet clutilTestlet) {
            }
        };
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options, control);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 1);
        this.assertEquality(((CLOption)clOptions.get(0)).getId(), 121);
    }

    public void test2PartParse() {
        CLOptionDescriptor[] options1 = new CLOptionDescriptor[]{YOU};
        CLOptionDescriptor[] options2 = new CLOptionDescriptor[]{ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        ClutilTestlet clutilTestlet = this;
        if (clutilTestlet == null) {
            throw null;
        }
        AbstractParserControl control1 = new AbstractParserControl(clutilTestlet){
            private final /* synthetic */ ClutilTestlet this$0;

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 121;
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(ClutilTestlet clutilTestlet) {
            }
        };
        CLArgsParser parser1 = new CLArgsParser(ARGLIST1, options1, control1);
        this.assertNull(parser1.getErrorString());
        Vector clOptions1 = parser1.getArguments();
        int size1 = clOptions1.size();
        this.assertEquality(size1, 1);
        this.assertEquality(((CLOption)clOptions1.get(0)).getId(), 121);
        CLArgsParser parser2 = new CLArgsParser(parser1.getUnparsedArgs(), options2);
        this.assertNull(parser2.getErrorString());
        Vector clOptions2 = parser2.getArguments();
        int size2 = clOptions2.size();
        this.assertEquality(size2, 7);
        this.assertEquality(((CLOption)clOptions2.get(0)).getId(), 0);
        this.assertEquality(((CLOption)clOptions2.get(1)).getId(), 97);
        this.assertEquality(((CLOption)clOptions2.get(2)).getId(), 99);
        this.assertEquality(((CLOption)clOptions2.get(3)).getId(), 108);
        this.assertEquality(((CLOption)clOptions2.get(4)).getId(), 101);
        this.assertEquality(((CLOption)clOptions2.get(5)).getId(), 114);
        this.assertEquality(((CLOption)clOptions2.get(6)).getId(), 0);
    }

    public void test2PartPartialParse() {
        CLOptionDescriptor[] options1 = new CLOptionDescriptor[]{YOU, ALL, CLEAR1};
        CLOptionDescriptor[] options2 = new CLOptionDescriptor[]{};
        ClutilTestlet clutilTestlet = this;
        if (clutilTestlet == null) {
            throw null;
        }
        AbstractParserControl control1 = new AbstractParserControl(clutilTestlet){
            private final /* synthetic */ ClutilTestlet this$0;

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 99;
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(ClutilTestlet clutilTestlet) {
            }
        };
        CLArgsParser parser1 = new CLArgsParser(ARGLIST1, options1, control1);
        this.assertNull(parser1.getErrorString());
        Vector clOptions1 = parser1.getArguments();
        int size1 = clOptions1.size();
        this.assertEquality(size1, 4);
        this.assertEquality(((CLOption)clOptions1.get(0)).getId(), 121);
        this.assertEquality(((CLOption)clOptions1.get(1)).getId(), 0);
        this.assertEquality(((CLOption)clOptions1.get(2)).getId(), 97);
        this.assertEquality(((CLOption)clOptions1.get(3)).getId(), 99);
        this.assert(parser1.getUnparsedArgs()[0].equals("ler"));
        CLArgsParser parser2 = new CLArgsParser(parser1.getUnparsedArgs(), options2);
        this.assertNull(parser2.getErrorString());
        Vector clOptions2 = parser2.getArguments();
        int size2 = clOptions2.size();
        this.assertEquality(size2, 2);
        this.assertEquality(((CLOption)clOptions2.get(0)).getId(), 0);
        this.assertEquality(((CLOption)clOptions2.get(1)).getId(), 0);
    }

    public void testDuplicatesFail() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        String[] DUPLICATE_ARGLIST = new String[]{"--you", "are", "--all", "-clear", "kid"};
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options);
        this.assertNull(parser.getErrorString());
    }

    public void testIncomplete2Args() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-Dstupid="}, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 1);
        CLOption option = (CLOption)clOptions.get(0);
        this.assertEquality(option.getId(), 68);
        this.assertEquality(option.getArgument(0), "stupid");
        this.assertEquality(option.getArgument(1), "");
    }

    public void testIncomplete2ArgsMixed() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] args = new String[]{"-Dstupid=", "-c"};
        CLArgsParser parser = new CLArgsParser(args, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 2);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 99);
        CLOption option = (CLOption)clOptions.get(0);
        this.assertEquality(option.getId(), 68);
        this.assertEquality(option.getArgument(0), "stupid");
        this.assertEquality(option.getArgument(1), "");
    }

    public void fail_testIncomplete2ArgsMixedNoEq() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] args = new String[]{"-Dstupid", "-c"};
        CLArgsParser parser = new CLArgsParser(args, options);
        this.assertNull(parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        this.assertEquality(size, 2);
        this.assertEquality(((CLOption)clOptions.get(1)).getId(), 99);
        CLOption option = (CLOption)clOptions.get(0);
        this.assertEquality(option.getId(), 68);
        this.assertEquality(option.getArgument(0), "stupid");
        this.assertEquality(option.getArgument(1), "");
    }

    static /* synthetic */ int access$0() {
        return YOU_OPT;
    }

    static /* synthetic */ int access$1() {
        return CLEAR1_OPT;
    }
}

