/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class DefaultServiceManager
implements ServiceManager {
    private final HashMap m_components = new HashMap();
    private final ServiceManager m_parent;
    private boolean m_readOnly;

    public DefaultServiceManager() {
        this(null);
    }

    public DefaultServiceManager(ServiceManager parent) {
        this.m_parent = parent;
    }

    public Object lookup(String role) throws ServiceException {
        Object component = this.m_components.get(role);
        if (null != component) {
            return component;
        }
        if (null != this.m_parent) {
            return this.m_parent.lookup(role);
        }
        throw new ServiceException("Unable to provide implementation for " + role);
    }

    public boolean hasService(String role) {
        boolean componentExists = false;
        try {
            this.lookup(role);
            componentExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return componentExists;
    }

    public void put(String role, Object object) {
        this.checkWriteable();
        this.m_components.put(role, object);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator components = this.m_components.keySet().iterator();
        buffer.append("Services:");
        while (components.hasNext()) {
            buffer.append("[");
            buffer.append(components.next());
            buffer.append("]");
        }
        return buffer.toString();
    }

    protected final ServiceManager getParent() {
        return this.m_parent;
    }

    protected final Map getComponentMap() {
        return this.m_components;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ServiceManager is read only and can not be modified");
        }
    }

    public void release(Object object) {
    }
}

