/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.ProxyIterator;

public class FilterIterator
extends ProxyIterator {
    private Predicate predicate;
    private Object nextObject;
    private boolean nextObjectSet = false;

    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    public Object next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextObject;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    private final boolean setNextObject() {
        Iterator iterator = this.getIterator();
        Predicate predicate = this.getPredicate();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!predicate.evaluate(e)) continue;
            this.nextObject = e;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }

    public FilterIterator() {
    }

    public FilterIterator(Iterator iterator) {
        super(iterator);
    }

    public FilterIterator(Iterator iterator, Predicate predicate) {
        super(iterator);
        this.predicate = predicate;
    }
}

