/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.texen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class Generator {
    public static final String OUTPUT_PATH = "output.path";
    public static final String TEMPLATE_PATH = "template.path";
    private static final String DEFAULT_TEXEN_PROPERTIES = "org/apache/velocity/texen/defaults/texen.properties";
    private Properties props = new Properties();
    private Context controlContext;
    private Hashtable fileWriters = new Hashtable();
    private static Generator instance = new Generator();
    static /* synthetic */ Class class$org$apache$velocity$app$Velocity;

    private Generator() {
        this.setDefaultProps();
    }

    public static Generator getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Generator(String propFile) {
        try {
            BufferedInputStream bi = null;
            try {
                bi = new BufferedInputStream(new FileInputStream(propFile));
                this.props.load(bi);
                Object var4_4 = null;
                if (bi == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (bi == null) throw throwable;
                bi.close();
                throw throwable;
            }
            bi.close();
            return;
        }
        catch (Exception e) {
            this.setDefaultProps();
        }
    }

    public Generator(Properties props) {
        this.props = (Properties)((Hashtable)props).clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setDefaultProps() {
        ClassLoader classLoader = (class$org$apache$velocity$app$Velocity == null ? (class$org$apache$velocity$app$Velocity = Generator.class$("org.apache.velocity.app.Velocity")) : class$org$apache$velocity$app$Velocity).getClassLoader();
        try {
            InputStream inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(DEFAULT_TEXEN_PROPERTIES);
                this.props.load(inputStream);
                Object var4_4 = null;
                if (inputStream == null) return;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (Exception ioe) {
            System.err.println("Cannot get default properties!");
        }
    }

    public void setTemplatePath(String templatePath) {
        ((Hashtable)this.props).put(TEMPLATE_PATH, templatePath);
    }

    public String getTemplatePath() {
        return this.props.getProperty(TEMPLATE_PATH);
    }

    public void setOutputPath(String outputPath) {
        ((Hashtable)this.props).put(OUTPUT_PATH, outputPath);
    }

    public String getOutputPath() {
        return this.props.getProperty(OUTPUT_PATH);
    }

    public String parse(String inputTemplate, String outputFile) throws Exception {
        return this.parse(inputTemplate, outputFile, null, null);
    }

    public String parse(String inputTemplate, String outputFile, String objectID, Object object) throws Exception {
        if (objectID != null && object != null) {
            this.controlContext.put(objectID, object);
        }
        Template template = Velocity.getTemplate(inputTemplate);
        if (outputFile == null || outputFile.equals("")) {
            StringWriter sw = new StringWriter();
            template.merge(this.controlContext, sw);
            return sw.toString();
        }
        FileWriter fileWriter = null;
        if (this.fileWriters.get(outputFile) == null) {
            fileWriter = new FileWriter(this.getOutputPath() + File.separator + outputFile);
            this.fileWriters.put(outputFile, fileWriter);
        } else {
            fileWriter = (FileWriter)this.fileWriters.get(outputFile);
        }
        VelocityContext vc = new VelocityContext(this.controlContext);
        template.merge(vc, fileWriter);
        return "";
    }

    public String parse(String controlTemplate, Context controlContext) throws Exception {
        this.controlContext = controlContext;
        this.fillContextDefaults(this.controlContext);
        this.fillContextProperties(this.controlContext);
        Template template = Velocity.getTemplate(controlTemplate);
        StringWriter sw = new StringWriter();
        template.merge(controlContext, sw);
        return sw.toString();
    }

    protected Context getContext(Hashtable objs) {
        this.fillContextHash(this.controlContext, objs);
        return this.controlContext;
    }

    protected void fillContextHash(Context context, Hashtable objs) {
        Enumeration enumeration = objs.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            context.put(key, objs.get(key));
        }
    }

    protected void fillContextDefaults(Context context) {
        context.put("generator", instance);
        context.put("outputDirectory", this.getOutputPath());
    }

    protected void fillContextProperties(Context context) {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String nm = (String)enumeration.nextElement();
            if (!nm.startsWith("context.objects.")) continue;
            String contextObj = this.props.getProperty(nm);
            int colon = nm.lastIndexOf(46);
            String contextName = nm.substring(colon + 1);
            try {
                Class<?> cls = Class.forName(contextObj);
                Object o = cls.newInstance();
                context.put(contextName, o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        Iterator iterator = this.fileWriters.values().iterator();
        while (iterator.hasNext()) {
            FileWriter fileWriter = (FileWriter)iterator.next();
            try {
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fileWriters.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

