/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaXPath;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.saxpath.SAXPathException;

public abstract class BaseXPath
extends JaXPath {
    private ContextSupport support;

    public BaseXPath(String xpathExpr) throws SAXPathException {
        super(xpathExpr);
    }

    public BaseXPath addNamespace(String prefix, String uri) throws JaxenException {
        NamespaceContext nsContext = this.getNamespaceContext();
        if (nsContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)nsContext).addNamespace(prefix, uri);
            return this;
        }
        throw new JaxenException("Operation not permitted while using a custom namespace context.");
    }

    public boolean booleanValueOf(Object context) throws JaxenException {
        return this.jaBooleanValueOf(this.getContext(context));
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    protected Context getContext(Object context) {
        if (context instanceof Context) {
            return (Context)context;
        }
        Context fullContext = new Context(this.getContextSupport());
        if (context instanceof List) {
            fullContext.setNodeSet((List)context);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(context);
            fullContext.setNodeSet(list);
        }
        return fullContext;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    public FunctionContext getFunctionContext() {
        return this.getContextSupport().getFunctionContext();
    }

    public NamespaceContext getNamespaceContext() {
        return this.getContextSupport().getNamespaceContext();
    }

    public abstract Navigator getNavigator();

    public VariableContext getVariableContext() {
        return this.getContextSupport().getVariableContext();
    }

    public Number numberValueOf(Object context) throws JaxenException {
        return this.jaNumberValueOf(this.getContext(context));
    }

    public List selectNodes(Object context) throws JaxenException {
        return this.jaSelectNodes(this.getContext(context));
    }

    public Object selectSingleNode(Object context) throws JaxenException {
        return this.jaSelectSingleNode(this.getContext(context));
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    public String valueOf(Object context) throws JaxenException {
        return this.jaValueOf(this.getContext(context));
    }
}

