/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import org.apache.commons.collections.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;

    public Object put(Object object, Object object2) {
        int n = this.size();
        Object object3 = null;
        if (n >= this.maximumSize && !this.containsKey(object)) {
            this.removeLRU();
        }
        object3 = super.put(object, object2);
        return object3;
    }

    protected void removeLRU() {
        Object object = this.getFirstKey();
        Object object2 = this.get(object);
        this.remove(object);
        this.processRemovedLRU(object, object2);
    }

    protected void processRemovedLRU(Object object, Object object2) {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.maximumSize = objectInput.readInt();
        int n = objectInput.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            this.put(object, object2);
            ++n2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.maximumSize);
        objectOutput.writeInt(this.size());
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            objectOutput.writeObject(e);
            Object object = this.get(e);
            objectOutput.writeObject(object);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int n) {
        this.maximumSize = n;
        while (this.size() > n) {
            this.removeLRU();
        }
    }

    public LRUMap() {
        this(100);
    }

    public LRUMap(int n) {
        super(n);
        this.maximumSize = n;
    }
}

