/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io.aelfred;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.dom4j.io.aelfred.SAXDriver;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static HashMap attributeTypeHash = new HashMap(13);
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_EXTERNAL = 2;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_ENTITY_CHECK = 128;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private HashMap elementInfo;
    private HashMap entityInfo;
    private HashMap notationInfo;
    private String currentElement;
    private int currentElementContent;
    private String basePublicId;
    private String baseURI;
    private int baseEncoding;
    private Reader baseReader;
    private InputStream baseInputStream;
    private char[] baseInputBuffer;
    private int baseInputBufferStart;
    private int baseInputBufferLength;
    private Stack entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }

    XmlParser() {
        this.cleanupVariables();
    }

    private void cleanupVariables() {
        this.dataBuffer = null;
        this.nameBuffer = null;
        this.elementInfo = null;
        this.entityInfo = null;
        this.notationInfo = null;
        this.currentElement = null;
        this.inputStack = null;
        this.entityStack = null;
        this.externalEntity = null;
        this.tagAttributes = null;
        this.rawReadBuffer = null;
        this.symbolTable = null;
    }

    private void copyIso8859_1ReadBuffer(int count, char mask) throws IOException {
        int i = 0;
        int j = this.readBufferPos;
        while (i < count) {
            char c = (char)(this.rawReadBuffer[i] & 0xFF);
            if ((c & mask) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(c));
            }
            this.readBuffer[j] = c;
            if (c == '\r') {
                this.sawCR = true;
            }
            ++i;
            ++j;
        }
        this.readBufferLength = j;
    }

    private void copyUcs2ReadBuffer(int count, int shift1, int shift2) throws SAXException {
        int j = this.readBufferPos;
        if (count > 0 && count % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, count);
        }
        if (shift1 == 0) {
            int i = 0;
            while (i < count) {
                char c = (char)(this.rawReadBuffer[i + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i]);
                this.readBuffer[j++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                i += 2;
            }
        } else {
            int i = 0;
            while (i < count) {
                char c = (char)(this.rawReadBuffer[i] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i + 1]);
                this.readBuffer[j++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                i += 2;
            }
        }
        this.readBufferLength = j;
    }

    private void copyUcs4ReadBuffer(int count, int shift1, int shift2, int shift3, int shift4) throws SAXException {
        int j = this.readBufferPos;
        if (count > 0 && count % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, count);
        }
        int i = 0;
        while (i < count) {
            int value = (this.rawReadBuffer[i] & 0xFF) << shift1 | (this.rawReadBuffer[i + 1] & 0xFF) << shift2 | (this.rawReadBuffer[i + 2] & 0xFF) << shift3 | (this.rawReadBuffer[i + 3] & 0xFF) << shift4;
            if (value < 65535) {
                this.readBuffer[j++] = (char)value;
                if (value == 13) {
                    this.sawCR = true;
                }
            } else if (value < 0x10FFFF) {
                this.readBuffer[j++] = (char)(0xD8 | (value -= 65536) >> 10 & 0x3FF);
                this.readBuffer[j++] = (char)(0xDC | value & 0x3FF);
            } else {
                this.encodingError("UCS-4 value out of range for Unicode", value, i);
            }
            i += 4;
        }
        this.readBufferLength = j;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int count) throws SAXException, IOException {
        int i = 0;
        int j = this.readBufferPos;
        char c = '\u0000';
        while (i < count) {
            block7: {
                byte b1;
                block8: {
                    block9: {
                        if ((b1 = this.rawReadBuffer[i++]) >= 0) break block8;
                        if ((b1 & 0xE0) != 192) break block9;
                        c = (char)((b1 & 0x1F) << 6 | this.getNextUtf8Byte(i++, count));
                        break block7;
                    }
                    if ((b1 & 0xF0) == 224) {
                        c = (char)((b1 & 0xF) << 12 | this.getNextUtf8Byte(i++, count) << 6 | this.getNextUtf8Byte(i++, count));
                        break block7;
                    } else {
                        if ((b1 & 0xF8) == 240) {
                            int iso646 = b1 & 7;
                            iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count);
                            iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count);
                            if ((iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count)) <= 65535) {
                                c = (char)iso646;
                                break block7;
                            } else {
                                if (iso646 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", iso646, 0);
                                }
                                this.readBuffer[j++] = (char)(0xD800 | (iso646 -= 65536) >> 10);
                                this.readBuffer[j++] = (char)(0xDC00 | iso646 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("unsupported five or six byte UTF-8 sequence", 0xFF & b1, i);
                        c = '\u0000';
                    }
                    break block7;
                }
                c = (char)b1;
            }
            this.readBuffer[j++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = j;
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String s) {
        this.dataBufferAppend(s.toCharArray(), 0, s.length());
    }

    private void dataBufferAppend(char[] ch, int start, int length) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + length);
        System.arraycopy(ch, start, this.dataBuffer, this.dataBufferPos, length);
        this.dataBufferPos += length;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            int i = 0;
            while (i < this.dataBufferPos) {
                if (!this.isWhitespace(this.dataBuffer[i])) {
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    this.dataBufferPos = 0;
                }
                ++i;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void dataBufferNormalize() {
        int i = 0;
        int j = 0;
        int end = this.dataBufferPos;
        while (j < end && this.isWhitespace(this.dataBuffer[j])) {
            ++j;
        }
        while (end > j && this.isWhitespace(this.dataBuffer[end - 1])) {
            --end;
        }
        while (j < end) {
            char c;
            if (this.isWhitespace(c = this.dataBuffer[j++])) {
                while (j < end && this.isWhitespace(this.dataBuffer[j++])) {
                }
                this.dataBuffer[i++] = 32;
                this.dataBuffer[i++] = this.dataBuffer[j - 1];
                continue;
            }
            this.dataBuffer[i++] = c;
        }
        this.dataBufferPos = i;
    }

    private String dataBufferToString() {
        String s = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return s;
    }

    public Iterator declaredAttributes(String elname) {
        return this.declaredAttributes((Object[])this.elementInfo.get(elname));
    }

    private Iterator declaredAttributes(Object[] element) {
        if (element == null) {
            return null;
        }
        HashMap attlist = (HashMap)element[2];
        if (attlist == null) {
            return null;
        }
        return attlist.keySet().iterator();
    }

    public Iterator declaredElements() {
        return this.elementInfo.keySet().iterator();
    }

    public Iterator declaredEntities() {
        return this.entityInfo.keySet().iterator();
    }

    public Iterator declaredNotations() {
        return this.notationInfo.keySet().iterator();
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] signature = new byte[4];
        this.is.mark(4);
        this.is.read(signature);
        this.is.reset();
        if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(signature, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(signature, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.encoding = 1;
        }
    }

    void doParse(String systemId, String publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        if (this.handler == null) {
            throw new IllegalStateException("no callback handler");
        }
        this.basePublicId = publicId;
        this.baseURI = systemId;
        this.baseReader = reader;
        this.baseInputStream = stream;
        this.initializeVariables();
        this.setInternalEntity("amp", "&#38;");
        this.setInternalEntity("lt", "&#60;");
        this.setInternalEntity("gt", "&#62;");
        this.setInternalEntity("apos", "&#39;");
        this.setInternalEntity("quot", "&#34;");
        this.handler.startDocument();
        this.pushURL("[document]", this.basePublicId, this.baseURI, this.baseReader, this.baseInputStream, encoding);
        try {
            this.parseDocument();
            this.handler.endDocument();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.baseReader != null) {
                try {
                    this.baseReader.close();
                }
                catch (IOException iOException) {}
            }
            if (this.baseInputStream != null) {
                try {
                    this.baseInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.cleanupVariables();
            throw throwable;
        }
        Object var7_6 = null;
        if (this.baseReader != null) {
            try {
                this.baseReader.close();
            }
            catch (IOException iOException) {}
        }
        if (this.baseInputStream != null) {
            try {
                this.baseInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {}
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this.cleanupVariables();
    }

    private void encodingError(String message, int value, int offset) throws SAXException {
        if (value != -1) {
            message = String.valueOf(message) + " (character code: 0x" + Integer.toHexString(value) + ')';
        }
        String uri = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        this.handler.error(message, uri, -1, offset + this.currentByteCount);
    }

    private void error(String message) throws SAXException {
        this.error(message, null, null);
    }

    private void error(String message, char textFound, String textExpected) throws SAXException {
        this.error(message, new Character(textFound).toString(), textExpected);
    }

    private void error(String message, String textFound, String textExpected) throws SAXException {
        if (textFound != null) {
            message = String.valueOf(message) + " (found \"" + textFound + "\")";
        }
        if (textExpected != null) {
            message = String.valueOf(message) + " (expected \"" + textExpected + "\")";
        }
        String uri = null;
        if (this.externalEntity != null) {
            uri = this.externalEntity.getURL().toString();
        }
        this.handler.error(message, uri, this.line, this.column);
        throw new SAXException(message);
    }

    private Object extendArray(Object array, int currentSize, int requiredSize) {
        if (requiredSize < currentSize) {
            return array;
        }
        Object[] newArray = null;
        int newSize = currentSize * 2;
        if (newSize <= requiredSize) {
            newSize = requiredSize + 1;
        }
        if (array instanceof char[]) {
            newArray = new char[newSize];
        } else if (array instanceof Object[]) {
            newArray = new Object[newSize];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    private void filterCR(boolean moreData) {
        int j;
        this.readBufferOverflow = -1;
        int i = j = this.readBufferPos;
        block3: while (j < this.readBufferLength) {
            switch (this.readBuffer[j]) {
                case '\r': {
                    if (j == this.readBufferLength - 1) {
                        if (moreData) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[i++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[j + 1] == '\n') {
                        ++j;
                    }
                    this.readBuffer[i] = 10;
                    break;
                }
                default: {
                    this.readBuffer[i] = this.readBuffer[j];
                    break;
                }
            }
            ++i;
            ++j;
        }
        this.readBufferLength = i;
    }

    private Object[] getAttribute(String elName, String name) {
        HashMap attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            return null;
        }
        Object[] attribute = (Object[])attlist.get(name);
        return attribute;
    }

    public String getAttributeDefaultValue(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[1];
    }

    public int getAttributeDefaultValueType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 30;
        }
        return (Integer)attribute[2];
    }

    public String getAttributeExpandedValue(String name, String aname) throws Exception {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        if (attribute[4] == null && attribute[1] != null) {
            char[] buf = new char[1];
            int flags = 10;
            int type = this.getAttributeType(name, aname);
            if (type != 1 && type != 0) {
                flags |= 4;
            }
            buf[0] = 34;
            this.pushCharArray(null, buf, 0, 1);
            this.pushString(null, (String)attribute[1]);
            this.pushCharArray(null, buf, 0, 1);
            attribute[4] = this.readLiteral(flags);
        }
        return (String)attribute[4];
    }

    public String getAttributeIterator(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[3];
    }

    public int getAttributeType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 0;
        }
        return (Integer)attribute[0];
    }

    public int getColumnNumber() {
        return this.column;
    }

    private int getContentType(Object[] element, int defaultType) {
        if (element == null) {
            return defaultType;
        }
        return (Integer)element[0];
    }

    private HashMap getElementAttributes(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (HashMap)element[2];
    }

    public String getElementContentModel(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (String)element[1];
    }

    public int getElementContentType(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        return this.getContentType(element, 0);
    }

    public String getEntityNotationName(String eName) {
        Object[] entity = (Object[])this.entityInfo.get(eName);
        if (entity == null) {
            return null;
        }
        return (String)entity[4];
    }

    public String getEntityPublicId(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[1];
    }

    public String getEntitySystemId(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[2];
    }

    public int getEntityType(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return 0;
        }
        return (Integer)entity[0];
    }

    public String getEntityValue(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[3];
    }

    public int getLineNumber() {
        return this.line;
    }

    private int getNextUtf8Byte(int pos, int count) throws SAXException, IOException {
        int val;
        if (pos < count) {
            val = this.rawReadBuffer[pos];
        } else {
            val = this.is.read();
            if (val == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, pos);
            }
        }
        if ((val & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", val, pos + 1);
        }
        return val & 0x3F;
    }

    public String getNotationPublicId(String nname) {
        Object[] notation = (Object[])this.notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[0];
    }

    public String getNotationSystemId(String nname) {
        Object[] notation = (Object[])this.notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[1];
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new HashMap();
        this.entityInfo = new HashMap();
        this.notationInfo = new HashMap();
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.inCDATA = false;
        this.symbolTable = new Object[1087][];
    }

    /*
     * Unable to fully structure code
     */
    public String intern(char[] ch, int start, int length) {
        block5: {
            index = 0;
            hash = 0;
            i = start;
            while (i < start + length) {
                hash = 31 * hash + ch[i];
                ++i;
            }
            bucket = this.symbolTable[hash = (hash & 0x7FFFFFFF) % 1087];
            if (bucket != null) ** GOTO lbl22
            bucket = new Object[8];
            break block5;
            while ((chFound = (char[])bucket[index]) != null) {
                if (chFound.length == length) {
                    i = 0;
                    while (i < chFound.length) {
                        if (ch[start + i] != chFound[i]) break;
                        if (i == length - 1) {
                            return (String)bucket[index + 1];
                        }
                        ++i;
                    }
                }
                index += 2;
lbl22:
                // 2 sources

                if (index < bucket.length) continue;
            }
            bucket = (Object[])this.extendArray(bucket, bucket.length, index);
        }
        this.symbolTable[hash] = bucket;
        s = new String(ch, start, length).intern();
        bucket[index] = s.toCharArray();
        bucket[index + 1] = s;
        return s;
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void parseAttDef(String elementName) throws Exception {
        String string = null;
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        int type = this.readAttType();
        if (type == 9 || type == 10) {
            string = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(elementName, name, type, string);
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String elementName = this.readNmtoken(true);
        boolean white = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!white) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(elementName);
            white = this.tryWhitespace();
        }
    }

    private void parseAttribute(String name) throws Exception {
        int flags = 10;
        String aname = this.readNmtoken(true);
        int type = this.getAttributeType(name, aname);
        this.parseEq();
        String value = type == 1 || type == 0 ? this.readLiteral(flags) : this.readLiteral(flags | 4);
        int i = 0;
        while (i < this.tagAttributePos) {
            if (aname.equals(this.tagAttributes[i])) {
                this.error("duplicate attribute", aname, null);
            }
            ++i;
        }
        this.handler.attribute(aname, value, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] newAttrib = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, newAttrib, 0, this.tagAttributePos);
            this.tagAttributes = newAttrib;
        }
        this.tagAttributes[this.tagAttributePos++] = aname;
    }

    private void parseCDSect() throws Exception {
        this.parseUntil("]]>");
        this.dataBufferFlush();
    }

    private void parseCharData() throws Exception {
        char c;
        int lineAugment = 0;
        int columnAugment = 0;
        int i = this.readBufferPos;
        while (i < this.readBufferLength) {
            c = this.readBuffer[i];
            switch (c) {
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    break;
                }
                case '&': 
                case '<': {
                    int start = this.readBufferPos;
                    ++columnAugment;
                    this.readBufferPos = i;
                    if (lineAugment > 0) {
                        this.line += lineAugment;
                        this.column = columnAugment;
                    } else {
                        this.column += columnAugment;
                    }
                    this.dataBufferAppend(this.readBuffer, start, i - start);
                    return;
                }
                case ']': {
                    if (i + 2 < this.readBufferLength && this.readBuffer[i + 1] == ']' && this.readBuffer[i + 2] == '>') {
                        this.error("character data may not contain ']]>'");
                    }
                    ++columnAugment;
                    break;
                }
                default: {
                    if (c < ' ' || c > '\ufffd') {
                        this.error("illegal XML character U+" + Integer.toHexString(c));
                    }
                }
                case '\t': 
                case '\r': {
                    ++columnAugment;
                }
            }
            ++i;
        }
        while (true) {
            c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseCharRef() throws SAXException, IOException {
        block20: {
            block19: {
                block17: {
                    block18: {
                        value = 0;
                        if (!this.tryRead('x')) break block18;
                        block8: while (true) {
                            c = this.readCh();
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': 
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': 
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value *= 16;
                                    value += Integer.parseInt(new Character(c).toString(), 16);
                                    continue block8;
                                }
                                default: {
                                    this.error("illegal character in character reference", c, null);
                                    ** GOTO lbl26
                                }
                                case ';': {
                                    if (value >= 32) break block17;
                                }
                            }
                            break;
                        }
                    }
                    block9: while (true) {
                        c = this.readCh();
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value *= 10;
                                value += Integer.parseInt(new Character(c).toString(), 10);
                                continue block9;
                            }
                            default: {
                                this.error("illegal character in character reference", c, null);
                            }
                            {
                                ** case 59:
                            }
                        }
                        break;
                    }
lbl26:
                    // 2 sources

                    if (value >= 32) break block17;
                    if (value != 10 && value != 9 && value != 13) break block19;
                }
                if ((value < 55296 || value > 57343) && value != 65534 && value != 65535 && value <= 0x10FFFF) break block20;
            }
            this.error("illegal XML character reference U+" + Integer.toHexString(value));
        }
        if (value <= 65535) {
            this.dataBufferAppend((char)value);
        } else if (value <= 0x10FFFF) {
            this.dataBufferAppend((char)(55296 | (value -= 65536) >> 10));
            this.dataBufferAppend((char)(56320 | value & 1023));
        } else {
            this.error("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
    }

    private void parseComment() throws Exception {
        boolean saved = this.expandPE;
        this.expandPE = false;
        this.parseUntil("--");
        this.require('>');
        this.expandPE = saved;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            boolean nesting = true;
            this.expandPE = false;
            int nest = 1;
            while (nest > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++nest;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --nest;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseContent() throws Exception {
        block17: while (true) {
            switch (this.currentElementContent) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.parseCharData();
                    break;
                }
                case 4: {
                    this.parseWhitespace();
                    break;
                }
            }
            char c = this.readCh();
            switch (c) {
                default: {
                    continue block17;
                }
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        continue block17;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    continue block17;
                }
                case '<': 
            }
            this.dataBufferFlush();
            c = this.readCh();
            switch (c) {
                case '!': {
                    c = this.readCh();
                    switch (c) {
                        case '-': {
                            this.require('-');
                            this.parseComment();
                            continue block17;
                        }
                        case '[': {
                            this.require("CDATA[");
                            this.handler.startCDATA();
                            this.inCDATA = true;
                            this.parseCDSect();
                            this.inCDATA = false;
                            this.handler.endCDATA();
                            continue block17;
                        }
                    }
                    this.error("expected comment or CDATA section", c, null);
                    continue block17;
                }
                case '?': {
                    this.parsePI();
                    continue block17;
                }
                case '/': {
                    this.parseETag();
                    return;
                }
            }
            this.unread(c);
            this.parseElement();
        }
    }

    private void parseContentspec(String name) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(name, 2, null, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(name, 1, null, null);
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(name, 3, this.dataBufferToString(), null);
        } else {
            this.parseElements();
            this.setElement(name, 4, this.dataBufferToString(), null);
        }
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                    break;
                }
            }
        }
    }

    private void parseDefault(String elementName, String name, int type, String string) throws Exception {
        int valueType = 31;
        String value = null;
        int flags = 168;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                valueType = 34;
                this.requireWhitespace();
                value = this.readLiteral(flags);
            } else if (this.tryRead("REQUIRED")) {
                valueType = 33;
            } else if (this.tryRead("IMPLIED")) {
                valueType = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            value = this.readLiteral(flags);
        }
        this.setAttribute(elementName, name, type, string, value, valueType);
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String doctypeName = this.readNmtoken(true);
        this.skipWhitespace();
        String[] ids = this.readExternalIds(false);
        this.handler.doctypeDecl(doctypeName, ids[0], ids[1]);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        if (ids[1] != null) {
            this.pushURL("[external subset]", ids[0], ids[1], null, null, null);
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (!this.tryRead('>')) {
                    this.expandPE = true;
                    this.parseMarkupdecl();
                    this.expandPE = false;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>');
        }
        this.handler.endDoctype();
        this.expandPE = false;
    }

    private void parseDocument() throws Exception {
        try {
            this.parseProlog();
            this.require('<');
            this.parseElement();
        }
        catch (EOFException eOFException) {
            this.error("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseElement() throws Exception {
        String gi;
        int oldElementContent = this.currentElementContent;
        String oldElement = this.currentElement;
        this.tagAttributePos = 0;
        this.currentElement = gi = this.readNmtoken(true);
        Object[] element = (Object[])this.elementInfo.get(gi);
        this.currentElementContent = this.getContentType(element, 1);
        boolean white = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!white) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(gi);
            white = this.tryWhitespace();
            c = this.readCh();
        }
        Iterator atts = this.declaredAttributes(element);
        if (atts != null) {
            block5: while (atts.hasNext()) {
                String aname = (String)atts.next();
                int i = 0;
                while (i < this.tagAttributePos) {
                    if (this.tagAttributes[i] == aname) continue block5;
                    ++i;
                }
                this.handler.attribute(aname, this.getAttributeExpandedValue(gi, aname), false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(gi);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(gi);
                this.handler.endElement(gi);
                break;
            }
        }
        this.currentElement = oldElement;
        this.currentElementContent = oldElementContent;
    }

    private void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseElements() throws Exception {
        char sep;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c = this.readCh();
        switch (c) {
            case ')': {
                this.dataBufferAppend(')');
                c = this.readCh();
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c);
                        break;
                    }
                    default: {
                        this.unread(c);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                sep = c;
                this.dataBufferAppend(c);
                break;
            }
            default: {
                this.error("bad separator in content model", c, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c = this.readCh();
            if (c == ')') break;
            if (c != sep) {
                this.error("bad separator in content model", c, null);
                return;
            }
            this.dataBufferAppend(c);
        }
        this.dataBufferAppend(')');
        c = this.readCh();
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c);
                return;
            }
        }
        this.unread(c);
    }

    private void parseEntityDecl() throws Exception {
        boolean peFlag = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String name = this.readNmtoken(true);
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String value = this.readLiteral(0);
            this.setInternalEntity(name, value);
        } else {
            String[] ids = this.readExternalIds(false);
            if (ids[1] == null) {
                this.error("system identifer missing", name, null);
            }
            boolean white = this.tryWhitespace();
            if (!peFlag && this.tryRead("NDATA")) {
                if (!white) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String notationName = this.readNmtoken(true);
                this.setExternalDataEntity(name, ids[0], ids[1], notationName);
            } else {
                this.setExternalTextEntity(name, ids[0], ids[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseEntityRef(boolean externalAllowed) throws SAXException, IOException {
        String name = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.error("reference to undeclared entity", name, null);
                break;
            }
            case 1: {
                this.pushString(name, this.getEntityValue(name));
                break;
            }
            case 3: {
                if (externalAllowed) {
                    this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
            case 2: {
                if (externalAllowed) {
                    this.error("unparsed entity reference in content", name, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
        }
    }

    private void parseEnumeration(boolean isNames) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(isNames));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(isNames));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect();
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    private void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String nname = this.readNmtoken(true);
        this.requireWhitespace();
        String[] ids = this.readExternalIds(true);
        if (ids[0] == null && ids[1] == null) {
            this.error("external identifer missing", nname, null);
        }
        this.setNotation(nname, ids[0], ids[1]);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parsePEReference() throws SAXException, IOException {
        String name = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 1: {
                if (this.inLiteral) {
                    this.pushString(name, this.getEntityValue(name));
                    break;
                }
                this.pushString(name, " " + this.getEntityValue(name) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                if (this.inLiteral) break;
                this.pushString(null, " ");
                break;
            }
        }
    }

    private void parsePI() throws SAXException, IOException {
        boolean saved = this.expandPE;
        this.expandPE = false;
        String name = this.readNmtoken(true);
        if ("xml".equalsIgnoreCase(name)) {
            this.error("Illegal processing instruction target", name, null);
        }
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        this.expandPE = saved;
        this.handler.processingInstruction(name, this.dataBufferToString());
    }

    private void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    private String parseTextDecl(boolean ignoreEncoding) throws SAXException, IOException {
        String encodingName = null;
        int flags = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String version = this.readLiteral(flags);
            if (!version.equals("1.0")) {
                this.error("unsupported XML version", version, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        encodingName = this.readLiteral(flags);
        if (!ignoreEncoding) {
            this.setupDecoding(encodingName);
        }
        this.skipWhitespace();
        this.require("?>");
        return encodingName;
    }

    private void parseUntil(String delim) throws SAXException, IOException {
        int startLine = this.line;
        try {
            while (!this.tryRead(delim)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, delim);
        }
    }

    private void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    private String parseXMLDecl(boolean ignoreEncoding) throws SAXException, IOException {
        String encodingName = null;
        String standalone = null;
        int flags = 112;
        this.require("version");
        this.parseEq();
        String version = this.readLiteral(flags);
        if (!version.equals("1.0")) {
            this.error("unsupported XML version", version, "1.0");
        }
        boolean white = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!white) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            encodingName = this.readLiteral(flags);
            if (!ignoreEncoding) {
                this.setupDecoding(encodingName);
            }
        }
        if (encodingName != null) {
            white = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!white) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            standalone = this.readLiteral(flags);
            if (!"yes".equals(standalone) && !"no".equals(standalone)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        return encodingName;
    }

    private void popInput() throws SAXException, IOException {
        switch (this.sourceType) {
            case 2: {
                if (this.externalEntity == null) break;
                this.handler.endExternalEntity(this.externalEntity.getURL().toString());
                break;
            }
            case 3: {
                if (this.baseURI != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.is.close();
                break;
            }
            case 5: {
                if (this.baseURI != null) {
                    this.handler.endExternalEntity(this.baseURI);
                }
                this.reader.close();
                break;
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Object[] input = (Object[])this.inputStack.pop();
        String s = (String)this.entityStack.pop();
        this.sourceType = (Integer)input[0];
        this.externalEntity = (URLConnection)input[1];
        this.readBuffer = (char[])input[2];
        this.readBufferPos = (Integer)input[3];
        this.readBufferLength = (Integer)input[4];
        this.line = (Integer)input[5];
        this.encoding = (Integer)input[6];
        this.readBufferOverflow = (Integer)input[7];
        this.is = (InputStream)input[8];
        this.currentByteCount = (Integer)input[9];
        this.column = (Integer)input[10];
        this.reader = (Reader)input[11];
    }

    private void pushCharArray(String ename, char[] ch, int start, int length) throws SAXException {
        this.pushInput(ename);
        this.sourceType = 1;
        this.readBuffer = ch;
        this.readBufferPos = start;
        this.readBufferLength = length;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String ename) throws SAXException {
        Object[] input = new Object[12];
        if (ename != null) {
            Iterator entities = ((AbstractList)this.entityStack).iterator();
            while (entities.hasNext()) {
                String e = (String)entities.next();
                if (e != ename) continue;
                this.error("recursive reference to entity", ename, null);
            }
        }
        this.entityStack.push(ename);
        if (this.sourceType == 0) {
            return;
        }
        input[0] = new Integer(this.sourceType);
        input[1] = this.externalEntity;
        input[2] = this.readBuffer;
        input[3] = new Integer(this.readBufferPos);
        input[4] = new Integer(this.readBufferLength);
        input[5] = new Integer(this.line);
        input[6] = new Integer(this.encoding);
        input[7] = new Integer(this.readBufferOverflow);
        input[8] = this.is;
        input[9] = new Integer(this.currentByteCount);
        input[10] = new Integer(this.column);
        input[11] = this.reader;
        this.inputStack.push(input);
    }

    private void pushString(String ename, String s) throws SAXException {
        char[] ch = s.toCharArray();
        this.pushCharArray(ename, ch, 0, ch.length);
    }

    private void pushURL(String ename, String publicId, String systemId, Reader reader, InputStream stream, String encoding) throws SAXException, IOException {
        Object input;
        boolean ignoreEncoding = false;
        this.pushInput(ename);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.currentByteCount = 0;
        if (systemId != null && this.externalEntity != null) {
            systemId = new URL(this.externalEntity.getURL(), systemId).toString();
        } else if (this.baseURI != null) {
            systemId = new URL(new URL(this.baseURI), systemId).toString();
        }
        if (reader == null && stream == null && systemId != null && (input = this.handler.resolveEntity(publicId, systemId)) != null) {
            if (input instanceof String) {
                systemId = (String)input;
            } else if (input instanceof InputStream) {
                stream = (InputStream)input;
            } else if (input instanceof Reader) {
                reader = (Reader)input;
            }
        }
        if (systemId != null) {
            this.handler.startExternalEntity(systemId);
        } else {
            this.handler.startExternalEntity("[unidentified data stream]");
        }
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        if (stream != null) {
            this.sourceType = 3;
            this.is = stream;
            Object url = null;
        } else {
            this.sourceType = 2;
            URL url = new URL(systemId);
            this.externalEntity = url.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (encoding == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            encoding = this.externalEntity.getContentType();
            int temp = encoding == null ? -1 : encoding.indexOf("charset");
            if (temp < 0) {
                encoding = null;
            } else {
                temp = encoding.indexOf(61, temp + 7);
                if ((temp = (encoding = encoding.substring(temp)).indexOf(59)) > 0) {
                    encoding = encoding.substring(0, temp);
                }
                if ((temp = encoding.indexOf(40)) > 0) {
                    encoding = encoding.substring(0, temp);
                }
                if ((temp = encoding.indexOf(34)) > 0) {
                    encoding = encoding.substring(temp + 1, encoding.indexOf(34, temp + 2));
                }
                encoding.trim();
            }
        }
        if (encoding != null) {
            this.encoding = 0;
            this.setupDecoding(encoding);
            ignoreEncoding = true;
        } else {
            this.detectEncoding();
            ignoreEncoding = false;
        }
        this.tryEncodingDecl(ignoreEncoding);
    }

    private void read8bitEncodingDeclaration() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        while (true) {
            int ch = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)ch;
            switch (ch) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private int readAttType() throws Exception {
        Integer type;
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return 9;
        }
        String typeString = this.readNmtoken(true);
        if (typeString.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((type = (Integer)attributeTypeHash.get(typeString)) == null) {
            this.error("illegal attribute type", typeString, null);
            return 0;
        }
        return type;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                    break;
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd') {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError) {
                        this.error("PE reference within decl in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            count = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = count < 0 ? this.readBufferPos : this.readBufferPos + count;
            if (this.readBufferLength > 0) {
                this.filterCR(count >= 0);
            }
            this.sawCR = false;
            return;
        }
        count = this.is.read(this.rawReadBuffer, 0, 16384);
        if (count <= 0) ** GOTO lbl46
        switch (this.encoding) {
            case 9: {
                this.copyIso8859_1ReadBuffer(count, '\u0080');
                break;
            }
            case 1: {
                this.copyUtf8ReadBuffer(count);
                break;
            }
            case 2: {
                this.copyIso8859_1ReadBuffer(count, '\u0000');
                break;
            }
            case 3: {
                this.copyUcs2ReadBuffer(count, 8, 0);
                break;
            }
            case 4: {
                this.copyUcs2ReadBuffer(count, 0, 8);
                break;
            }
            case 5: {
                this.copyUcs4ReadBuffer(count, 24, 16, 8, 0);
                break;
            }
            case 6: {
                this.copyUcs4ReadBuffer(count, 0, 8, 16, 24);
                break;
            }
            case 7: {
                this.copyUcs4ReadBuffer(count, 16, 24, 0, 8);
                break;
            }
            case 8: {
                this.copyUcs4ReadBuffer(count, 8, 0, 24, 16);
                break;
            }
lbl46:
            // 1 sources

            this.readBufferLength = this.readBufferPos;
            break;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(count >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && count >= 0) {
                this.readDataChunk();
            }
        }
        if (count > 0) {
            this.currentByteCount += count;
        }
    }

    private String[] readExternalIds(boolean inNotation) throws Exception {
        String[] ids = new String[2];
        int flags = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            ids[0] = this.readLiteral(4 | flags);
            if (inNotation) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    ids[1] = this.readLiteral(flags);
                }
            } else {
                this.requireWhitespace();
                ids[1] = this.readLiteral(flags);
            }
            int i = 0;
            while (i < ids[0].length()) {
                c = ids[0].charAt(i);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1)) {
                    this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
                }
                ++i;
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            ids[1] = this.readLiteral(flags);
        }
        return ids;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLiteral(int flags) throws SAXException, IOException {
        int startLine = this.line;
        boolean saved = this.expandPE;
        char delim = this.readCh();
        if (delim != '\"' && delim != '\'' && delim != '\u0000') {
            this.error("expected '\"' or \"'\"", delim, null);
            return null;
        }
        this.inLiteral = true;
        if ((flags & 0x10) != 0) {
            this.expandPE = false;
        }
        char[] ourBuf = this.readBuffer;
        try {
            char c = this.readCh();
            block7: while (c != delim || this.readBuffer != ourBuf) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if ((flags & 8) == 0) break;
                        c = ' ';
                        break;
                    }
                    case '&': {
                        c = this.readCh();
                        if (c == '#') {
                            if ((flags & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                this.dataBufferAppend('#');
                                continue block7;
                            }
                            this.parseCharRef();
                        } else {
                            this.unread(c);
                            if ((flags & 2) > 0) {
                                this.parseEntityRef(false);
                            } else if ((flags & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String name = this.readNmtoken(true);
                                this.require(';');
                                if ((flags & 0x80) != 0 && this.getEntityType(name) == 0) {
                                    this.error("General entity '" + name + "' must be declared before use");
                                }
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(name);
                                this.dataBufferAppend(';');
                            }
                        }
                        c = this.readCh();
                        continue block7;
                    }
                    case '<': {
                        if ((flags & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                    }
                }
                this.dataBufferAppend(c);
                c = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, new Character(delim).toString());
        }
        this.inLiteral = false;
        this.expandPE = saved;
        if ((flags & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private String readNmtoken(boolean isName) throws SAXException, IOException {
        char c;
        int i = this.readBufferPos;
        block7: while (i < this.readBufferLength) {
            c = this.readBuffer[i];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int start = this.readBufferPos;
                    if (i == start) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, start, i - start);
                }
                default: {
                    if (i == this.readBufferPos && isName) {
                        if (!Character.isUnicodeIdentifierStart(c) && c != ':' && c != '_') {
                            this.error("Not a name start character, U+" + Integer.toHexString(c));
                        }
                    } else if (!Character.isUnicodeIdentifierPart(c) && c != '-' && c != ':' && c != '_' && c != '.' && !XmlParser.isExtender(c)) {
                        this.error("Not a name character, U+" + Integer.toHexString(c));
                    }
                    ++i;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (isName && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String s = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return s;
                }
            }
            if (!(this.nameBufferPos == 0 && isName || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private void require(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c != delim) {
            this.error("required character", c, new Character(delim).toString());
        }
    }

    private void require(String delim) throws SAXException, IOException {
        char[] ch;
        int length = delim.length();
        if (length < this.dataBuffer.length) {
            ch = this.dataBuffer;
            delim.getChars(0, length, ch, 0);
        } else {
            ch = delim.toCharArray();
        }
        if (length <= this.readBufferLength - this.readBufferPos) {
            int offset = this.readBufferPos;
            int i = 0;
            while (i < length) {
                if (ch[i] != this.readBuffer[offset]) {
                    this.error("required string", null, delim);
                }
                ++i;
                ++offset;
            }
            this.readBufferPos = offset;
        } else {
            int i = 0;
            while (i < length) {
                this.require(ch[i]);
                ++i;
            }
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void setAttribute(String elName, String name, int type, String enumeration, String value, int valueType) throws Exception {
        HashMap<String, Object[]> attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            attlist = new HashMap<String, Object[]>();
        }
        if (attlist.get(name) != null) {
            return;
        }
        Object[] attribute = new Object[]{new Integer(type), value, new Integer(valueType), enumeration, null};
        attlist.put(name, attribute);
        this.setElement(elName, 0, null, attlist);
    }

    private void setElement(String name, int contentType, String contentModel, HashMap attributes) throws Exception {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            element = new Object[]{new Integer(0), null, null};
        } else if (contentType != 0 && (Integer)element[0] != 0) {
            return;
        }
        if (contentType != 0) {
            element[0] = new Integer(contentType);
        }
        if (contentModel != null) {
            element[1] = contentModel;
        }
        if (attributes != null) {
            element[2] = attributes;
        }
        this.elementInfo.put(name, element);
    }

    private void setEntity(String eName, int eClass, String pubid, String sysid, String value, String nName) {
        if (this.entityInfo.get(eName) == null) {
            Object[] entity = new Object[]{new Integer(eClass), pubid, sysid, value, nName};
            this.entityInfo.put(eName, entity);
        }
    }

    private void setExternalDataEntity(String eName, String pubid, String sysid, String nName) {
        this.setEntity(eName, 2, pubid, sysid, null, nName);
    }

    private void setExternalTextEntity(String eName, String pubid, String sysid) {
        this.setEntity(eName, 3, pubid, sysid, null, null);
    }

    void setHandler(SAXDriver handler) {
        this.handler = handler;
    }

    private void setInternalEntity(String eName, String value) {
        this.setEntity(eName, 1, null, null, value, null);
    }

    private void setNotation(String nname, String pubid, String sysid) throws Exception {
        if (this.notationInfo.get(nname) == null) {
            Object[] notation = new Object[]{pubid, sysid};
            this.notationInfo.put(nname, notation);
        }
    }

    private void setupDecoding(String encodingName) throws SAXException, IOException {
        encodingName = encodingName.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (encodingName.equals("ISO-8859-1") || encodingName.equals("8859_1") || encodingName.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (encodingName.equals("US-ASCII") || encodingName.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (encodingName.equals("UTF-8") || encodingName.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                this.error("unsupported ASCII-derived encoding", encodingName, "UTF-8, US-ASCII, or ISO-8859-1");
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(encodingName.equals("ISO-10646-UCS-2") || encodingName.equals("UTF-16") || encodingName.equals("UTF-16BE") || encodingName.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", encodingName, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!encodingName.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", encodingName, "ISO-10646-UCS-4");
            }
            return;
        }
        if (encodingName.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (encodingName.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (encodingName.equals("UTF-16") || encodingName.equals("ISO-10646-UCS-2")) {
            encodingName = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, encodingName);
        this.sourceType = 5;
        this.is = null;
    }

    private void skipWhitespace() throws SAXException, IOException {
        int lineAugment = 0;
        int columnAugment = 0;
        int i = this.readBufferPos;
        block5: while (i < this.readBufferLength) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++columnAugment;
                    break;
                }
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    break;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (lineAugment > 0) {
                        this.line += lineAugment;
                        this.column = columnAugment;
                    } else {
                        this.column += columnAugment;
                    }
                    return;
                }
            }
            ++i;
        }
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2) {
        return sig[0] == b1 && sig[1] == b2;
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2, byte b3, byte b4) {
        return sig[0] == b1 && sig[1] == b2 && sig[2] == b3 && sig[3] == b4;
    }

    private String tryEncodingDecl(boolean ignoreEncoding) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            this.dataBufferFlush();
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(ignoreEncoding);
                }
                return this.parseXMLDecl(ignoreEncoding);
            }
            this.unread("xml".toCharArray(), 3);
            this.parsePI();
        }
        return null;
    }

    private boolean tryRead(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c == delim) {
            return true;
        }
        this.unread(c);
        return false;
    }

    private boolean tryRead(String delim) throws SAXException, IOException {
        char[] ch = delim.toCharArray();
        int i = 0;
        while (i < ch.length) {
            char c = this.readCh();
            if (c != ch[i]) {
                this.unread(c);
                if (i != 0) {
                    this.unread(ch, i);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] ch, int length) throws SAXException {
        int i = 0;
        while (i < length) {
            if (ch[i] == '\n') {
                --this.line;
                this.column = -1;
            }
            ++i;
        }
        if (length < this.readBufferPos) {
            this.readBufferPos -= length;
        } else {
            this.pushCharArray(null, ch, 0, length);
            this.sourceType = 4;
        }
    }
}

