/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractJdbcConnection
extends AbstractLogEnabled
implements Connection,
Recyclable,
Disposable,
Initializable {
    protected Connection m_connection;
    protected Pool m_pool;
    protected PreparedStatement m_test_statement;
    protected SQLException m_test_exception;
    protected int m_num_uses = 15;

    private AbstractJdbcConnection() {
    }

    public AbstractJdbcConnection(Connection connection, boolean oradb) {
        this(connection, oradb ? "select 1 from dual" : "select 1");
    }

    public AbstractJdbcConnection(Connection connection, String keepAlive) {
        this.m_connection = connection;
        this.initialize();
        if (null != keepAlive && "".equals(keepAlive.trim())) {
            try {
                this.m_test_statement = this.prepareStatement(keepAlive);
            }
            catch (SQLException se) {
                this.m_test_statement = null;
                this.m_test_exception = se;
            }
        } else {
            this.m_test_statement = null;
            this.m_test_exception = null;
        }
    }

    public void initialize() {
    }

    public void enableLogging(Logger log) {
        super.enableLogging(log);
        if (this.m_test_statement == null && this.m_test_exception != null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not prepare test statement", (Throwable)this.m_test_exception);
            }
            this.m_test_exception = null;
        }
    }

    protected void setPool(Pool pool) {
        this.m_pool = pool;
    }

    public void recycle() {
        --this.m_num_uses;
        this.m_test_exception = null;
    }

    public boolean isClosed() throws SQLException {
        if (this.m_connection.isClosed()) {
            return true;
        }
        if (this.m_num_uses <= 0) {
            this.dispose();
            return true;
        }
        if (this.m_test_statement != null) {
            try {
                this.m_test_statement.executeQuery();
            }
            catch (SQLException se) {
                this.dispose();
                return true;
            }
        }
        return false;
    }

    public void close() throws SQLException {
        this.clearWarnings();
        this.m_pool.put(this);
    }

    public void dispose() {
        block2: {
            try {
                this.m_connection.close();
            }
            catch (SQLException se) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Could not close connection", (Throwable)se);
            }
        }
    }

    public abstract void setTypeMap(Map var1) throws SQLException;

    public abstract Map getTypeMap() throws SQLException;

    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    public abstract void clearWarnings() throws SQLException;

    public abstract SQLWarning getWarnings() throws SQLException;

    public abstract int getTransactionIsolation() throws SQLException;

    public abstract void setTransactionIsolation(int var1) throws SQLException;

    public abstract String getCatalog() throws SQLException;

    public abstract void setCatalog(String var1) throws SQLException;

    public abstract boolean isReadOnly() throws SQLException;

    public abstract void setReadOnly(boolean var1) throws SQLException;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public abstract void rollback() throws SQLException;

    public abstract void commit() throws SQLException;

    public abstract boolean getAutoCommit() throws SQLException;

    public abstract void setAutoCommit(boolean var1) throws SQLException;

    public abstract String nativeSQL(String var1) throws SQLException;

    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    public abstract Statement createStatement() throws SQLException;
}

