/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.collections.Buffer;
import org.apache.avalon.excalibur.collections.VariableSizeBuffer;
import org.apache.avalon.excalibur.concurrent.Mutex;
import org.apache.avalon.excalibur.pool.ManagablePool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;

public final class VariableSizePool
implements Pool,
Disposable,
ManagablePool {
    private boolean m_disposed = false;
    private final Buffer m_buffer;
    private final ObjectFactory m_factory;
    private final Mutex m_mutex = new Mutex();
    private final long m_key;

    public VariableSizePool(ObjectFactory factory, int size) throws Exception {
        this(factory, size, -1L);
    }

    public VariableSizePool(ObjectFactory factory, int size, long key) throws Exception {
        this.m_buffer = new VariableSizeBuffer(size);
        this.m_factory = factory;
        this.m_key = key;
        int i = 0;
        while (i < size) {
            this.m_buffer.add(this.m_factory.newInstance());
            ++i;
        }
    }

    public Poolable get() {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        return (Poolable)this.m_buffer.remove();
    }

    public void put(Poolable object) {
        if (this.m_disposed) {
            try {
                this.m_factory.decommission((Object)object);
            }
            catch (Exception exception) {}
        } else {
            this.m_buffer.add((Object)object);
        }
    }

    public void dispose() {
        this.m_disposed = true;
        while (!this.m_buffer.isEmpty()) {
            try {
                this.m_factory.decommission(this.m_buffer.remove());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shrink(int byNum, long key) throws IllegalAccessException {
        if (this.m_key < 0L) throw new IllegalAccessException();
        if (this.m_key != key) {
            throw new IllegalAccessException();
        }
        try {
            try {
                this.m_mutex.acquire();
                int num = Math.min(byNum, this.m_buffer.size());
                int i = 0;
                while (i < num) {
                    this.m_factory.decommission(this.m_buffer.remove());
                    ++i;
                }
            }
            catch (Exception e) {
                Object var7_7 = null;
                this.m_mutex.release();
                return;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void grow(int byNum, long key) throws IllegalAccessException {
        if (this.m_key < 0L) throw new IllegalAccessException();
        if (this.m_key != key) {
            throw new IllegalAccessException();
        }
        try {
            try {
                this.m_mutex.acquire();
                int i = 0;
                while (i < byNum) {
                    this.m_buffer.add(this.m_factory.newInstance());
                    ++i;
                }
            }
            catch (Exception ie) {
                Object var6_6 = null;
                this.m_mutex.release();
                return;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_mutex.release();
            throw throwable;
        }
        this.m_mutex.release();
    }

    public int size(long key) throws IllegalAccessException {
        if (this.m_key < 0L || this.m_key != key) {
            throw new IllegalAccessException();
        }
        return this.m_buffer.size();
    }
}

