/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.validation;

import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class XMLGrammarPoolImpl
implements XMLGrammarPool {
    protected static final int TABLE_SIZE = 11;
    protected Entry[] fGrammars = null;
    private static final boolean DEBUG = false;

    public XMLGrammarPoolImpl() {
        this.fGrammars = new Entry[11];
    }

    public XMLGrammarPoolImpl(int n) {
        this.fGrammars = new Entry[n];
    }

    public Grammar[] retrieveInitialGrammarSet(String string) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            Object object;
            int n = this.fGrammars.length;
            Grammar[] grammarArray = new Grammar[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                object = this.fGrammars[n3];
                while (object != null) {
                    if (object.desc.getGrammarType().equals(string)) {
                        grammarArray[n2++] = object.grammar;
                    }
                    object = object.next;
                }
                ++n3;
            }
            object = new Grammar[n2];
            System.arraycopy(grammarArray, 0, object, 0, n2);
            Grammar[] grammarArray2 = object;
            return grammarArray2;
        }
    }

    public void cacheGrammars(String string, Grammar[] grammarArray) {
        int n = 0;
        while (n < grammarArray.length) {
            this.putGrammar(grammarArray[n]);
            ++n;
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
        return this.getGrammar(xMLGrammarDescription);
    }

    public void putGrammar(Grammar grammar) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            Entry entry;
            XMLGrammarDescription xMLGrammarDescription = grammar.getGrammarDescription();
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry2 = this.fGrammars[n2];
            while (entry2 != null) {
                if (entry2.hash == n && this.equals(entry2.desc, xMLGrammarDescription)) {
                    entry2.grammar = grammar;
                    return;
                }
                entry2 = entry2.next;
            }
            this.fGrammars[n2] = entry = new Entry(n, xMLGrammarDescription, grammar, this.fGrammars[n2]);
        }
    }

    public Grammar getGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n2];
            while (entry != null) {
                if (entry.hash == n && this.equals(entry.desc, xMLGrammarDescription)) {
                    Grammar grammar = entry.grammar;
                    return grammar;
                }
                entry = entry.next;
            }
            Grammar grammar = null;
            return grammar;
        }
    }

    public Grammar removeGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.hash == n && this.equals(entry.desc, xMLGrammarDescription)) {
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        this.fGrammars[n2] = entry.next;
                    }
                    Grammar grammar = entry.grammar;
                    entry.grammar = null;
                    Grammar grammar2 = grammar;
                    return grammar2;
                }
                entry2 = entry;
                entry = entry.next;
            }
            Grammar grammar = null;
            return grammar;
        }
    }

    public boolean containsGrammar(XMLGrammarDescription xMLGrammarDescription) {
        Entry[] entryArray = this.fGrammars;
        synchronized (entryArray) {
            int n = this.hashCode(xMLGrammarDescription);
            int n2 = (n & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[n2];
            while (entry != null) {
                if (entry.hash == n && this.equals(entry.desc, xMLGrammarDescription)) {
                    boolean bl = true;
                    return bl;
                }
                entry = entry.next;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean equals(XMLGrammarDescription xMLGrammarDescription, XMLGrammarDescription xMLGrammarDescription2) {
        return xMLGrammarDescription.equals(xMLGrammarDescription2);
    }

    public int hashCode(XMLGrammarDescription xMLGrammarDescription) {
        return xMLGrammarDescription.hashCode();
    }

    public void print(XMLGrammarDescription xMLGrammarDescription) {
        if (!xMLGrammarDescription.getGrammarType().equals("DTD") && xMLGrammarDescription.getGrammarType().equals("XSD")) {
            XSDDescription xSDDescription = (XSDDescription)xMLGrammarDescription;
            System.out.println("Context = " + xSDDescription.getContextType());
            System.out.println("TargetNamespace = " + xSDDescription.getTargetNamespace());
            String[] stringArray = xSDDescription.getLocationHints();
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                System.out.println("LocationHint " + n + " = " + stringArray[n]);
                ++n;
            }
            System.out.println("Triggering Component = " + xSDDescription.getTriggeringComponent());
            System.out.println("EnclosingElementName =" + xSDDescription.getEnclosingElementName());
        }
    }

    protected static final class Entry {
        public int hash;
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public Entry next;

        protected Entry(int n, XMLGrammarDescription xMLGrammarDescription, Grammar grammar, Entry entry) {
            this.hash = n;
            this.desc = xMLGrammarDescription;
            this.grammar = grammar;
            this.next = entry;
        }
    }
}

