/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.lang.Layer;
import org.apache.avalon.excalibur.lang.ThreadContextAccessor;
import org.apache.avalon.excalibur.lang.ThreadContextPolicy;

public final class LayeredThreadContext {
    private static final RuntimePermission c_setThreadContextPermission = new RuntimePermission("LayeredThreadContext.setThreadContext");
    private static final RuntimePermission c_pushPermission = new RuntimePermission("LayeredThreadContext.push");
    private static final InheritableThreadLocal c_context = new CloningInheritableThreadLocal();
    private final ThreadContextAccessor m_accessor = new InnerThreadContextAccessor();
    private final ThreadContextPolicy m_policy;
    private final ArrayList m_layers = new ArrayList();

    public static LayeredThreadContext getThreadContext() {
        return (LayeredThreadContext)c_context.get();
    }

    public static void setThreadContext(LayeredThreadContext threadContext) throws SecurityException {
        LayeredThreadContext oldThreadContext;
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(c_setThreadContextPermission);
        }
        if (null != (oldThreadContext = (LayeredThreadContext)c_context.get())) {
            oldThreadContext.deactivate();
        }
        c_context.set(threadContext);
        if (null != threadContext) {
            threadContext.activate();
        }
    }

    public LayeredThreadContext(ThreadContextPolicy policy) {
        if (null == policy) {
            throw new NullPointerException("policy property is null");
        }
        this.m_policy = policy;
    }

    public synchronized void pop(Object key) throws IllegalArgumentException {
        int top;
        int size = this.m_layers.size();
        int i = top = size - 1;
        while (i >= 0) {
            Layer layer = (Layer)this.m_layers.get(i);
            if (layer.matchesKey(key)) {
                int j = top;
                while (j >= i) {
                    this.m_layers.remove(j);
                    --j;
                }
                return;
            }
            --i;
        }
        throw new IllegalArgumentException("Unknown key " + key);
    }

    public synchronized void push(Object key, Map map, boolean isDivider) throws SecurityException, IllegalArgumentException {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(c_pushPermission);
        }
        HashMap data = new HashMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object keyValue = keys.next();
            Object value = map.get(keyValue);
            String keyString = keyValue.toString();
            this.m_policy.verifyKeyValue(keyString, value);
            data.put(keyString, value);
        }
        this.m_layers.add(new Layer(key, data, isDivider));
    }

    protected synchronized Object contextGet(String key) {
        int top;
        int size = this.m_layers.size();
        int i = top = size - 1;
        while (i >= 0) {
            Layer layer = (Layer)this.m_layers.get(i);
            if (layer.containsKey(key)) {
                return layer.get(key);
            }
            if (layer.isDivider()) break;
            --i;
        }
        return null;
    }

    protected synchronized boolean contextContainsKey(String key) {
        int top;
        int size = this.m_layers.size();
        int i = top = size - 1;
        while (i >= 0) {
            Layer layer = (Layer)this.m_layers.get(i);
            if (layer.containsKey(key)) {
                return true;
            }
            if (layer.isDivider()) break;
            --i;
        }
        return false;
    }

    protected synchronized LayeredThreadContext duplicate() {
        LayeredThreadContext context = new LayeredThreadContext(this.m_policy);
        int size = this.m_layers.size();
        int i = 0;
        while (i < size) {
            Layer layer = (Layer)this.m_layers.get(i);
            context.m_layers.add(layer);
            ++i;
        }
        return context;
    }

    private void activate() {
        this.m_policy.activate(this.m_accessor);
    }

    private void deactivate() {
        this.m_policy.deactivate(this.m_accessor);
    }

    private class InnerThreadContextAccessor
    implements ThreadContextAccessor {
        private InnerThreadContextAccessor() {
        }

        public boolean containsKey(String key) {
            return LayeredThreadContext.this.contextContainsKey(key);
        }

        public Object get(String key) {
            return LayeredThreadContext.this.contextGet(key);
        }
    }

    private static class CloningInheritableThreadLocal
    extends InheritableThreadLocal {
        private CloningInheritableThreadLocal() {
        }

        protected Object childValue(Object parentValue) {
            LayeredThreadContext context = (LayeredThreadContext)parentValue;
            return context.duplicate();
        }
    }
}

