/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ClonerToResultTree {
    private ResultTreeHandler m_rth;
    private TransformerImpl m_transformer;

    public ClonerToResultTree(TransformerImpl transformerImpl, ResultTreeHandler resultTreeHandler) {
        this.m_rth = resultTreeHandler;
        this.m_transformer = transformerImpl;
    }

    public void cloneToResultTree(Node node, boolean bl) throws TransformerException {
        try {
            boolean bl2 = false;
            XPathContext xPathContext = this.m_transformer.getXPathContext();
            DOMHelper dOMHelper = xPathContext.getDOMHelper();
            switch (node.getNodeType()) {
                case 3: {
                    Text text = (Text)node;
                    String string = null;
                    if (bl2) {
                        if (!dOMHelper.isIgnorableWhitespace(text) && (string = text.getData()) != null && string.trim().length() == 0) {
                            string = null;
                        }
                    } else {
                        Node node2 = node.getParentNode();
                        if (node2 != null) {
                            if (node2.getNodeType() != 9 && (string = text.getData()) != null && string.length() == 0) {
                                string = null;
                            }
                        } else {
                            string = text.getData();
                            if (string != null && string.length() == 0) {
                                string = null;
                            }
                        }
                    }
                    if (string != null) {
                        if (dOMHelper.isIgnorableWhitespace(text)) {
                            this.m_rth.ignorableWhitespace(string.toCharArray(), 0, string.length());
                        } else {
                            this.m_rth.characters(string.toCharArray(), 0, string.length());
                        }
                    }
                    break;
                }
                case 1: {
                    if (bl) {
                        this.m_rth.addAttributes(node);
                        this.m_rth.processNSDecls(node);
                    }
                    String string = dOMHelper.getNamespaceOfNode(node);
                    String string2 = dOMHelper.getLocalNameOfNode(node);
                    this.m_rth.startElement(string, string2, node.getNodeName(), null);
                    break;
                }
                case 4: {
                    this.m_rth.startCDATA();
                    String string = ((CDATASection)node).getData();
                    this.m_rth.characters(string.toCharArray(), 0, string.length());
                    this.m_rth.endCDATA();
                    break;
                }
                case 2: {
                    if (!this.m_rth.isDefinedNSDecl((Attr)node)) {
                        String string = dOMHelper.getNamespaceOfNode(node);
                        String string3 = dOMHelper.getLocalNameOfNode(node);
                        this.m_rth.addAttribute(string, string3, node.getNodeName(), "CDATA", ((Attr)node).getValue());
                    }
                    break;
                }
                case 8: {
                    this.m_rth.comment(((Comment)node).getData());
                    break;
                }
                case 5: {
                    EntityReference entityReference = (EntityReference)node;
                    this.m_rth.entityReference(entityReference.getNodeName());
                    break;
                }
                case 7: {
                    ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                    this.m_rth.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                    break;
                }
                default: {
                    this.m_transformer.getMsgMgr().error(null, 56, new Object[]{node.getNodeName()});
                    break;
                }
                case 9: 
                case 11: {
                    return;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }
}

