/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Referenceable;
import org.apache.avalon.excalibur.naming.AbstractContext;
import org.apache.avalon.excalibur.naming.Namespace;

public abstract class AbstractLocalContext
extends AbstractContext {
    protected Context m_parent;
    protected Namespace m_namespace;

    protected boolean isDestroyableContext(Object object) throws NamingException {
        return this.getClass().isInstance(object);
    }

    protected abstract Context newContext() throws NamingException;

    protected abstract Context cloneContext() throws NamingException;

    protected void bind(Name name, Object object, boolean rebind) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to bind self");
        }
        if (1 == name.size()) {
            boolean alreadyBound = false;
            try {
                this.localLookup(name);
                alreadyBound = true;
            }
            catch (NamingException ne) {
                // empty catch block
            }
            if (!rebind && alreadyBound) {
                throw new NameAlreadyBoundException(name.get(0));
            }
            if (object instanceof Referenceable) {
                object = ((Referenceable)object).getReference();
            }
            Name atom = name.getPrefix(1);
            object = this.m_namespace.getStateToBind(object, atom, this, this.m_environment);
            this.doLocalBind(name, object);
        } else {
            Context context = this.lookupSubContext(this.getPathName(name));
            if (rebind) {
                context.rebind(this.getLeafName(name), object);
            } else {
                context.bind(this.getLeafName(name), object);
            }
        }
    }

    protected abstract void doLocalBind(Name var1, Object var2) throws NamingException;

    public void close() {
        this.m_parent = null;
        this.m_namespace = null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context context = this.newContext();
        this.bind(name, (Object)context);
        return context;
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Failed to destroy self");
        }
        if (1 == name.size()) {
            Object object = null;
            try {
                object = this.localLookup(name);
            }
            catch (NamingException ne) {
                return;
            }
            this.checkUnbindContext(name, object);
            this.doLocalUnbind(name);
        } else {
            Context context = this.lookupSubContext(this.getPathName(name));
            Object object = null;
            Name atom = this.getLeafName(name);
            try {
                object = context.lookup(atom);
            }
            catch (NamingException ne) {
                return;
            }
            this.checkUnbindContext(atom, object);
            context.destroySubcontext(atom);
        }
    }

    protected void checkUnbindContext(Name name, Object entry) throws NamingException {
        if (!this.isDestroyableContext(entry)) {
            throw new NotContextException(name.toString());
        }
        Context context = (Context)entry;
        if (context.list("").hasMoreElements()) {
            throw new ContextNotEmptyException(name.toString());
        }
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Namespace has no notion of a 'full name'");
    }

    protected NameParser getNameParser() throws NamingException {
        return this.m_namespace.getNameParser();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (this.isSelf(name)) {
            return this.doLocalList();
        }
        Context context = this.lookupSubContext(name);
        return context.list("");
    }

    protected abstract NamingEnumeration doLocalList() throws NamingException;

    protected abstract NamingEnumeration doLocalListBindings() throws NamingException;

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (this.isSelf(name)) {
            return this.doLocalListBindings();
        }
        Context context = this.lookupSubContext(name);
        return context.listBindings("");
    }

    public Object lookup(Name name) throws NamingException {
        if (this.isSelf(name)) {
            return this.cloneContext();
        }
        if (1 == name.size()) {
            return this.localLookup(name);
        }
        Context context = this.lookupSubContext(this.getPathName(name));
        return context.lookup(this.getLeafName(name));
    }

    protected Object localLookup(Name name) throws NamingException {
        Object value = this.doLocalLookup(name);
        try {
            Name atom = name.getPrefix(1);
            return this.m_namespace.getObjectInstance(value, atom, this, this.m_environment);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("getObjectInstance failed");
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected abstract Object doLocalLookup(Name var1) throws NamingException;

    protected Context lookupSubContext(Name name) throws NamingException {
        Name atom = name.getPrefix(1);
        Object object = this.localLookup(atom);
        if (1 != name.size()) {
            if (!(object instanceof Context)) {
                throw new NotContextException(atom.toString());
            }
            object = ((Context)object).lookup(name.getSuffix(1));
        }
        if (!(object instanceof Context)) {
            throw new NotContextException(name.toString());
        }
        return (Context)object;
    }

    public void unbind(Name name) throws NamingException {
        if (this.isSelf(name)) {
            throw new InvalidNameException("Cannot unbind self");
        }
        if (1 == name.size()) {
            this.doLocalUnbind(name);
        } else {
            Context context = this.lookupSubContext(this.getPathName(name));
            context.unbind(this.getLeafName(name));
        }
    }

    protected abstract void doLocalUnbind(Name var1) throws NamingException;

    public AbstractLocalContext(Namespace namespace, Hashtable environment, Context parent) {
        super(environment);
        this.m_namespace = namespace;
        this.m_parent = parent;
    }
}

