/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;

public class DefaultLogTargetFactoryManager
extends AbstractLoggable
implements LogTargetFactoryManager,
Contextualizable,
Configurable {
    private final Map m_factories = new HashMap();
    private Context m_context;

    public final LogTargetFactory getLogTargetFactory(String factoryName) {
        LogTargetFactory factory = (LogTargetFactory)this.m_factories.get(factoryName);
        return factory;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    /*
     * WARNING - void declaration
     */
    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] confs = configuration.getChildren("factory");
        int i = 0;
        while (i < confs.length) {
            void logTargetFactory;
            String factoryClass = confs[i].getAttribute("class");
            String factoryType = confs[i].getAttribute("type");
            try {
                LogTargetFactory logTargetFactory2 = (LogTargetFactory)this.getClass().getClassLoader().loadClass(factoryClass).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("cannot find LogTargetFactory class " + factoryClass, (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new ConfigurationException("cannot instantiate LogTargetFactory class " + factoryClass, (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigurationException("cannot access LogTargetFactory class " + factoryClass, (Throwable)iae);
            }
            if (logTargetFactory instanceof Loggable) {
                ((Loggable)logTargetFactory).setLogger(this.getLogger());
            }
            if (logTargetFactory instanceof Contextualizable) {
                try {
                    ((Contextualizable)logTargetFactory).contextualize(this.m_context);
                }
                catch (ContextException ce) {
                    throw new ConfigurationException("cannot contextualize LogTargetFactory " + factoryClass, (Throwable)ce);
                }
            }
            if (logTargetFactory instanceof LogTargetFactoryManageable) {
                ((LogTargetFactoryManageable)logTargetFactory).setLogTargetFactoryManager(this);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added new LogTargetFactory of type " + factoryType);
            }
            this.m_factories.put(factoryType, logTargetFactory);
            ++i;
        }
    }
}

