/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.log.Logger;

public class JdbcConnection
extends AbstractLoggable
implements Connection,
Recyclable,
Disposable,
Initializable {
    protected Connection m_connection;
    protected Pool m_pool;
    protected PreparedStatement m_test_statement;
    protected SQLException m_test_exception;
    protected int m_num_uses = 15;

    public void initialize() {
    }

    protected void setPool(Pool pool) {
        this.m_pool = pool;
    }

    public final void setLogger(Logger log) {
        super.setLogger(log);
        if (this.m_test_statement == null && this.m_test_exception != null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Could not prepare test statement", (Throwable)this.m_test_exception);
            }
            this.m_test_exception = null;
        }
    }

    public final Statement createStatement() throws SQLException {
        return this.m_connection.createStatement();
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.m_connection.prepareStatement(sql);
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.m_connection.prepareCall(sql);
    }

    public final String nativeSQL(String sql) throws SQLException {
        return this.m_connection.nativeSQL(sql);
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.m_connection.setAutoCommit(autoCommit);
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.m_connection.getAutoCommit();
    }

    public final void commit() throws SQLException {
        this.m_connection.commit();
    }

    public final void rollback() throws SQLException {
        this.m_connection.rollback();
    }

    public final void close() throws SQLException {
        this.clearWarnings();
        this.m_pool.put(this);
    }

    public final void dispose() {
        block2: {
            try {
                this.m_connection.close();
            }
            catch (SQLException se) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Could not close connection", (Throwable)se);
            }
        }
    }

    public final void recycle() {
        --this.m_num_uses;
        this.m_test_exception = null;
    }

    public final boolean isClosed() throws SQLException {
        if (this.m_connection.isClosed()) {
            return true;
        }
        if (this.m_num_uses <= 0) {
            this.dispose();
            return true;
        }
        if (this.m_test_statement != null) {
            try {
                this.m_test_statement.executeQuery();
            }
            catch (SQLException se) {
                this.dispose();
                return true;
            }
        }
        return false;
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.m_connection.getMetaData();
    }

    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.m_connection.setReadOnly(readOnly);
    }

    public final boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    public final void setCatalog(String catalog) throws SQLException {
        this.m_connection.setCatalog(catalog);
    }

    public final String getCatalog() throws SQLException {
        return this.m_connection.getCatalog();
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        this.m_connection.setTransactionIsolation(level);
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.m_connection.getTransactionIsolation();
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.m_connection.getWarnings();
    }

    public final void clearWarnings() throws SQLException {
        this.m_connection.clearWarnings();
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.m_connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.m_connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public final Map getTypeMap() throws SQLException {
        return this.m_connection.getTypeMap();
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.m_connection.setTypeMap(map);
    }

    public JdbcConnection(Connection connection, boolean oradb) {
        this(connection, oradb ? "select 1 from dual" : "select 1");
    }

    public JdbcConnection(Connection connection, String keepAlive) {
        this.m_connection = connection;
        this.initialize();
        if (keepAlive != null && "".equals(keepAlive.trim())) {
            try {
                this.m_test_statement = this.prepareStatement(keepAlive);
            }
            catch (SQLException se) {
                this.m_test_statement = null;
                this.m_test_exception = se;
            }
        } else {
            this.m_test_statement = null;
            this.m_test_exception = null;
        }
    }
}

