/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class J2eeDataSource
extends AbstractLoggable
implements DataSourceComponent {
    public static final String JDBC_NAME = "java:comp/env/jdbc/";
    protected DataSource m_dataSource = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_dataSource == null) {
            String databaseName = configuration.getChild("dbname").getValue();
            try {
                InitialContext initialContext = new InitialContext();
                this.m_dataSource = (DataSource)initialContext.lookup(JDBC_NAME + databaseName);
            }
            catch (NamingException ne) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Problem with JNDI lookup of datasource", (Throwable)ne);
                }
                throw new ConfigurationException("Could not use JNDI to find datasource", (Throwable)ne);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.m_dataSource == null) {
            throw new SQLException("Can not access DataSource object");
        }
        return this.m_dataSource.getConnection();
    }
}

