/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import org.apache.avalon.excalibur.datasource.JdbcConnection;
import org.apache.avalon.excalibur.datasource.JdbcConnectionFactory;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.HardResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class JdbcConnectionPool
extends HardResourceLimitingPool
implements Runnable,
Disposable,
Initializable {
    private Thread m_initThread;
    private final boolean m_autoCommit;
    private boolean m_noConnections = false;

    public void initialize() {
        this.m_initThread = new Thread(this);
        this.m_initThread.start();
    }

    protected final Poolable newPoolable() throws Exception {
        JdbcConnection conn = (JdbcConnection)super.newPoolable();
        conn.setPool(this);
        return conn;
    }

    public Poolable get() throws Exception {
        JdbcConnection obj;
        if (!this.m_initialized) {
            if (this.m_noConnections) {
                throw new IllegalStateException("There are no connections in the pool, check your settings.");
            }
            if (this.m_initThread == null) {
                throw new IllegalStateException("You cannot get a Connection before the pool is initialized.");
            }
            this.m_initThread.join();
        }
        if ((obj = (JdbcConnection)super.get()).isClosed()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JdbcConnection was closed, creating one to take its place");
            }
            try {
                try {
                    this.m_mutex.lock();
                    if (this.m_active.contains(obj)) {
                        this.m_active.remove(obj);
                    }
                    this.m_factory.decommission(obj);
                    obj = (JdbcConnection)this.newPoolable();
                    this.m_active.add(obj);
                }
                catch (Exception e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not get an open connection", (Throwable)e);
                    }
                    throw e;
                }
                Object var3_2 = null;
                this.m_mutex.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_mutex.unlock();
                throw throwable;
            }
        }
        if (obj.getAutoCommit() != this.m_autoCommit) {
            obj.setAutoCommit(this.m_autoCommit);
        }
        return obj;
    }

    public void run() {
        block5: {
            try {
                this.grow(this.m_min);
                if (JdbcConnectionPool.super.size() > 0) {
                    this.m_initialized = true;
                } else {
                    this.m_noConnections = true;
                    if (this.getLogger().isFatalErrorEnabled()) {
                        this.getLogger().fatalError("Excalibur could not create any connections.  Examine your settings to make sure they are correct.  Make sure you can connect with the same settings on your machine.");
                    }
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("Caught an exception during initialization", (Throwable)e);
            }
        }
    }

    public JdbcConnectionPool(JdbcConnectionFactory factory, DefaultPoolController controller, int min, int max, boolean autoCommit) throws Exception {
        super((ObjectFactory)factory, controller, max);
        this.m_min = min;
        this.m_autoCommit = autoCommit;
    }
}

