/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log.LogKit;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.AbstractOutputTarget;

public class DefaultOutputLogTarget
extends AbstractOutputTarget {
    protected Writer m_output;

    protected void initPattern() {
        PatternFormatter patternFormatter = new PatternFormatter();
        patternFormatter.setFormat("%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}");
        this.m_formatter = patternFormatter;
    }

    public DefaultOutputLogTarget() {
        this.m_output = new OutputStreamWriter(System.out);
        this.initPattern();
    }

    public DefaultOutputLogTarget(OutputStream outputStream) {
        this.m_output = new OutputStreamWriter(outputStream);
        this.initPattern();
    }

    public DefaultOutputLogTarget(Writer writer) {
        this.m_output = writer;
        this.initPattern();
    }

    protected void output(String string) {
        try {
            this.m_output.write(string);
            this.m_output.flush();
        }
        catch (IOException iOException) {
            LogKit.log("IOException in DefaultOutputLogTarget", iOException);
        }
    }

    public void setFormat(String string) {
        ((PatternFormatter)this.m_formatter).setFormat(string);
    }
}

