/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class URLResourceLoader
extends ResourceLoader {
    private Vector urlroots = new Vector();

    public void init(ExtendedProperties configuration) {
        this.rsvc.info("URLResourceLoader : initialization starting.");
        this.urlroots = configuration.getVector("root");
        int i = 0;
        while (i < this.urlroots.size()) {
            this.rsvc.info("URLResourceLoader : adding root '" + (String)this.urlroots.get(i) + "'");
            ++i;
        }
        this.rsvc.info("URLResourceLoader : initialization complete.");
    }

    public synchronized InputStream getResourceStream(String url) throws ResourceNotFoundException {
        int i = 0;
        while (i < this.urlroots.size()) {
            try {
                String full = (String)this.urlroots.get(i);
                URL u = new URL(full + url);
                URLConnection conn = u.openConnection();
                InputStream inputStream = conn.getInputStream();
                if (inputStream != null) {
                    return inputStream;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        String msg = "URLResourceLoader :  Error: cannot find resource " + url;
        this.rsvc.error("URLResourceLoader : " + msg);
        throw new ResourceNotFoundException(msg);
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

