/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.template;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrintWriter
extends PrintWriter {
    public static final String LINE_SEPARATOR = "\n";
    public static final int LINE_SEPARATOR_LEN = "\n".length();
    private boolean prevCharWasNewLine = false;
    private StringBuffer lineBuffer = new StringBuffer();
    private int lineBufferLength;

    public PrettyPrintWriter(OutputStream pOut) {
        super(pOut);
    }

    public PrettyPrintWriter(Writer pOut) {
        super(pOut);
    }

    public PrettyPrintWriter(Writer pOut, boolean pAutoFlush) {
        super(pOut, pAutoFlush);
    }

    public void close() {
        if (this.lineBuffer.length() > 0) {
            this.writeLine();
        }
        super.close();
    }

    public void write(char[] pBuffer, int pOffset, int pLength) {
        int i = pOffset;
        while (i < pOffset + pLength) {
            char c = pBuffer[i];
            if (c != '\r') {
                if (c == '\n') {
                    this.lineBuffer.append(LINE_SEPARATOR);
                    this.lineBufferLength += LINE_SEPARATOR_LEN;
                    this.writeLine();
                } else {
                    this.lineBuffer.append(c);
                    ++this.lineBufferLength;
                }
            }
            ++i;
        }
    }

    public void write(int c) {
        if (c != 13) {
            this.lineBuffer.append(c);
            ++this.lineBufferLength;
            if (c == 10) {
                this.writeLine();
            }
        }
    }

    public void write(String pText, int pOffset, int pLength) {
        this.write(pText.toCharArray(), pOffset, pLength);
    }

    public void println() {
        this.write(LINE_SEPARATOR);
    }

    protected void writeLine() {
        boolean allSpaces = true;
        if (this.lineBufferLength == 1 && this.lineBuffer.charAt(0) == '\n') {
            if (!this.prevCharWasNewLine) {
                allSpaces = false;
                this.prevCharWasNewLine = true;
            }
        } else {
            int j = 0;
            while (j < this.lineBufferLength) {
                char tempChar = this.lineBuffer.charAt(j);
                if (!Character.isWhitespace(tempChar)) {
                    this.prevCharWasNewLine = false;
                    allSpaces = false;
                    break;
                }
                ++j;
            }
        }
        if (!allSpaces) {
            char[] lineChars = this.lineBuffer.toString().toCharArray();
            super.write(lineChars, 0, lineChars.length);
        }
        this.lineBuffer = new StringBuffer();
        this.lineBufferLength = 0;
    }
}

