/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.excalibur.component.ExcaliburComponentSelector;
import org.apache.avalon.excalibur.i18n.Bundle;
import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.excalibur.i18n.BundleLoader;
import org.apache.avalon.excalibur.i18n.BundleMatcher;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Loggable;

public class BundleSelector
extends ExcaliburComponentSelector {
    public static String ROLE = "org.apache.avalon.excalibur.i18n.BundleSelector";
    protected ComponentManager manager = null;
    protected Map cacheNotFound = new HashMap();
    private Map loaders = new HashMap();
    private List matchers = new LinkedList();
    private BundleLoader defaultLoader;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] loaderConfs = configuration.getChild("loaders").getChildren("loader");
        int i = 0;
        while (i < loaderConfs.length) {
            BundleLoader loader = (BundleLoader)this.getInstance(loaderConfs[i].getAttribute("class"));
            if (loader instanceof Loggable) {
                ((Loggable)loader).setLogger(this.getLogger());
            }
            try {
                if (loader instanceof Composable) {
                    ((Composable)loader).compose(this.manager);
                }
            }
            catch (ComponentException e) {
                throw new ConfigurationException("unable to compose loader", (Throwable)e);
            }
            loader.configure(loaderConfs[i]);
            loader.setBundleSelector(this);
            this.loaders.put(loaderConfs[i].getAttribute("type-name"), loader);
            ++i;
        }
        this.defaultLoader = (BundleLoader)this.loaders.get(configuration.getChild("matchers").getAttribute("default-type"));
        if (this.defaultLoader == null) {
            throw new ConfigurationException("default loader not specified (matchers/@default-type)");
        }
        Configuration[] matcherConfs = configuration.getChild("matchers").getChildren("matcher");
        int i2 = 0;
        while (i2 < matcherConfs.length) {
            BundleMatcher matcher = (BundleMatcher)this.getInstance(configuration.getAttribute("class"));
            matcher.configure(matcherConfs[i2]);
            this.matchers.add(matcher);
            ++i2;
        }
    }

    private Object getInstance(String className) throws ConfigurationException {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to load object", (Throwable)e);
        }
    }

    public Component select(Object hint) throws ComponentException {
        Component bundle = this.select((BundleInfo)hint);
        if (bundle == null) {
            throw new ComponentException("Unable to locate bundle: " + hint);
        }
        return bundle;
    }

    public Component select(String name, String localeName) throws ComponentException {
        return this.select(new BundleInfo(name, new Locale(localeName, localeName)));
    }

    private Component select(BundleInfo bundleInfo) {
        Bundle bundle;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("_getBundle: " + bundleInfo);
        }
        if ((bundle = (Bundle)this.selectCached(bundleInfo)) == null && !this.isNotFoundBundle(bundleInfo)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("not found in cache, loading: " + bundleInfo);
            }
            BundleSelector bundleSelector = this;
            synchronized (bundleSelector) {
                bundle = (Bundle)this.selectCached(bundleInfo);
                if (bundle == null && !this.isNotFoundBundle(bundleInfo)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("synchronized: not found in cache, loading: " + bundleInfo);
                    }
                    bundle = this.loadBundle(bundleInfo);
                    BundleInfo parentBundleInfo = bundleInfo.getParent();
                    while (bundle == null && parentBundleInfo != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("synchronized: still not found, trying parent: " + parentBundleInfo);
                        }
                        bundle = this.loadBundle(parentBundleInfo);
                        this.updateCache(parentBundleInfo, bundle);
                        parentBundleInfo = parentBundleInfo.getParent();
                    }
                    this.updateCache(bundleInfo, bundle);
                }
            }
        }
        return (Component)bundle;
    }

    private Bundle loadBundle(BundleInfo bundleInfo) {
        String type = null;
        int i = 0;
        while (i < this.matchers.size()) {
            type = ((BundleMatcher)this.matchers.get(i)).getType(bundleInfo);
            if (type != null) break;
            ++i;
        }
        BundleLoader loader = null;
        if (type != null) {
            loader = (BundleLoader)this.loaders.get(type);
        }
        if (loader == null) {
            loader = this.defaultLoader;
        }
        return loader.loadBundle(bundleInfo);
    }

    protected Component selectCached(BundleInfo bundleInfo) {
        Component bundle;
        block3: {
            bundle = null;
            try {
                bundle = super.select((Object)bundleInfo);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Returning from cache: " + bundleInfo);
                }
            }
            catch (ComponentException e) {
                if (!this.getLogger().isDebugEnabled()) break block3;
                this.getLogger().debug("Not found in cache: " + bundleInfo);
            }
        }
        return bundle;
    }

    protected boolean isNotFoundBundle(BundleInfo bundleInfo) {
        BundleInfo result = (BundleInfo)this.cacheNotFound.get(bundleInfo);
        if (result != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Returning from not_found_cache: " + bundleInfo);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Not found in not_found_cache: " + bundleInfo);
        }
        return result != null;
    }

    protected void updateCache(BundleInfo bundleInfo, Bundle bundle) {
        if (bundle == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating not_found_cache: " + bundleInfo);
            }
            this.cacheNotFound.put(bundleInfo, bundleInfo);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Updating cache: " + bundleInfo);
            }
            super.addComponentInstance((Object)bundleInfo, (Component)bundle);
        }
    }
}

