/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.concurrent;

public class DijkstraSemaphore {
    private int m_count;
    private int m_maxCount;
    private Object m_starvationLock = new Object();

    public void acquire() throws InterruptedException {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            while (this.m_count == 0) {
                this.wait();
            }
            --this.m_count;
            Object object = this.m_starvationLock;
            synchronized (object) {
                if (this.m_count == 0) {
                    this.m_starvationLock.notify();
                }
            }
        }
    }

    public boolean tryAcquire() {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            if (this.m_count != 0) {
                --this.m_count;
                Object object = this.m_starvationLock;
                synchronized (object) {
                    if (this.m_count == 0) {
                        this.m_starvationLock.notify();
                    }
                }
                return true;
            }
            return false;
        }
    }

    public void release() {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            ++this.m_count;
            if (this.m_count > this.m_maxCount) {
                this.m_count = this.m_maxCount;
            }
            this.notify();
        }
    }

    public void release(int count) {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            this.m_count = this.m_count + count > this.m_maxCount ? this.m_maxCount : (this.m_count += count);
            this.notifyAll();
        }
    }

    public void acquireAll() throws InterruptedException {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            int index = 0;
            while (index < this.m_maxCount) {
                this.acquire();
                ++index;
            }
        }
    }

    public void releaseAll() {
        DijkstraSemaphore dijkstraSemaphore = this;
        synchronized (dijkstraSemaphore) {
            this.release(this.m_maxCount);
            this.notifyAll();
        }
    }

    public void starvationCheck() throws InterruptedException {
        Object object = this.m_starvationLock;
        synchronized (object) {
            if (this.m_count != 0) {
                this.m_starvationLock.wait();
            }
        }
    }

    public DijkstraSemaphore(int maxCount) {
        this(maxCount, maxCount);
    }

    public DijkstraSemaphore(int maxCount, int initialCount) {
        this.m_count = initialCount;
        this.m_maxCount = maxCount;
    }
}

