/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    public Move() {
        this.forceOverwrite = true;
    }

    protected void doFileOperations() {
        Object object;
        Object object2;
        Enumeration<Object> enumeration;
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                Object object3;
                object2 = (String)enumeration.nextElement();
                if (((String)object2).equals(object = (String)this.fileCopyMap.get(object2))) {
                    this.log("Skipping self-move of " + (String)object2, this.verbosity);
                    continue;
                }
                boolean bl = false;
                File file = new File((String)object2);
                File file2 = new File((String)object);
                try {
                    this.log("Attempting to rename: " + (String)object2 + " to " + (String)object, this.verbosity);
                    bl = this.renameFile(file, file2, this.filtering, this.forceOverwrite);
                }
                catch (IOException iOException) {
                    object3 = "Failed to rename " + (String)object2 + " to " + (String)object + " due to " + iOException.getMessage();
                    throw new BuildException((String)object3, iOException, this.location);
                }
                if (bl) continue;
                try {
                    this.log("Moving " + (String)object2 + " to " + (String)object, this.verbosity);
                    FilterSetCollection filterSetCollection = new FilterSetCollection();
                    if (this.filtering) {
                        filterSetCollection.addFilterSet(this.project.getGlobalFilterSet());
                    }
                    object3 = this.getFilterSets().elements();
                    while (object3.hasMoreElements()) {
                        filterSetCollection.addFilterSet((FilterSet)object3.nextElement());
                    }
                    this.getFileUtils().copyFile(file, file2, filterSetCollection, this.forceOverwrite);
                    file = new File((String)object2);
                    if (file.delete()) continue;
                    throw new BuildException("Unable to delete file " + file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    object3 = "Failed to copy " + (String)object2 + " to " + (String)object + " due to " + iOException.getMessage();
                    throw new BuildException((String)object3, iOException, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object = new File((String)enumeration.nextElement());
                if (((File)object).exists()) continue;
                if (!((File)object).mkdirs()) {
                    this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                this.log("Moved " + n + " empty directories to " + this.destDir.getAbsolutePath());
            }
        }
        if (this.filesets.size() > 0) {
            enumeration = this.filesets.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (FileSet)enumeration.nextElement();
                object = ((FileSet)object2).getDir(this.project);
                if (!this.okToDelete((File)object)) continue;
                this.deleteDir((File)object);
            }
        }
    }

    protected boolean okToDelete(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                if (!this.okToDelete(file2)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void deleteDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (!file2.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + file2.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(file2);
            ++n;
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!file.delete()) {
            throw new BuildException("Unable to delete directory " + file.getAbsolutePath());
        }
    }

    protected boolean renameFile(File file, File file2, boolean bl, boolean bl2) throws IOException, BuildException {
        boolean bl3 = true;
        if (!bl) {
            File file3;
            String string = file2.getParent();
            if (string != null && !(file3 = new File(string)).exists()) {
                file3.mkdirs();
            }
            if (file2.exists() && !file2.delete()) {
                throw new BuildException("Unable to remove existing file " + file2);
            }
            bl3 = file.renameTo(file2);
        } else {
            bl3 = false;
        }
        return bl3;
    }
}

