/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class Ant
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    Vector properties = new Vector();
    Project p1;

    public void init() {
        this.p1 = new Project();
        this.p1.setJavaVersionProperty();
        this.p1.addTaskDefinition("property", (Class)this.project.getTaskDefinitions().get("property"));
    }

    private void reinit() {
        this.init();
        int i = 0;
        while (i < this.properties.size()) {
            Property p = (Property)this.properties.elementAt(i);
            Property newP = (Property)this.p1.createTask("property");
            newP.setName(p.getName());
            if (p.getValue() != null) {
                newP.setValue(p.getValue());
            }
            if (p.getFile() != null) {
                newP.setFile(p.getFile());
            }
            if (p.getResource() != null) {
                newP.setResource(p.getResource());
            }
            this.properties.setElementAt(newP, i);
            ++i;
        }
    }

    private void initializeProject() {
        Vector listeners = this.project.getBuildListeners();
        int i = 0;
        while (i < listeners.size()) {
            this.p1.addBuildListener((BuildListener)listeners.elementAt(i));
            ++i;
        }
        if (this.output != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(this.output));
                DefaultLogger logger = new DefaultLogger();
                logger.setMessageOutputLevel(2);
                logger.setOutputPrintStream(out);
                logger.setErrorPrintStream(out);
                this.p1.addBuildListener(logger);
            }
            catch (IOException ex) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        Hashtable taskdefs = this.project.getTaskDefinitions();
        Enumeration et = taskdefs.keys();
        while (et.hasMoreElements()) {
            String taskName = (String)et.nextElement();
            Class taskClass = (Class)taskdefs.get(taskName);
            this.p1.addTaskDefinition(taskName, taskClass);
        }
        Hashtable typedefs = this.project.getDataTypeDefinitions();
        Enumeration e = typedefs.keys();
        while (e.hasMoreElements()) {
            String typeName = (String)e.nextElement();
            Class typeClass = (Class)typedefs.get(typeName);
            this.p1.addDataTypeDefinition(typeName, typeClass);
        }
        Hashtable prop1 = this.project.getProperties();
        e = prop1.keys();
        while (e.hasMoreElements()) {
            String arg = (String)e.nextElement();
            String value = (String)prop1.get(arg);
            this.p1.setProperty(arg, value);
        }
    }

    public void execute() throws BuildException {
        try {
            File file;
            if (this.p1 == null) {
                this.reinit();
            }
            if (this.dir == null) {
                this.dir = this.project.getBaseDir();
            }
            this.initializeProject();
            this.p1.setBaseDir(this.dir);
            this.p1.setUserProperty("basedir", this.dir.getAbsolutePath());
            Enumeration e = this.properties.elements();
            while (e.hasMoreElements()) {
                Property p = (Property)e.nextElement();
                p.execute();
            }
            if (this.antFile == null) {
                this.antFile = "build.xml";
            }
            if (!(file = new File(this.antFile)).isAbsolute()) {
                this.antFile = new File(this.dir, this.antFile).getAbsolutePath();
                file = new File(this.antFile);
                if (!file.isFile()) {
                    throw new BuildException("Build file " + file + " not found.");
                }
            }
            this.p1.setUserProperty("ant.file", this.antFile);
            ProjectHelper.configureProject(this.p1, new File(this.antFile));
            if (this.target == null) {
                this.target = this.p1.getDefaultTarget();
            }
            if (this.p1.getBaseDir().equals(this.project.getBaseDir()) && this.p1.getProperty("ant.file").equals(this.project.getProperty("ant.file")) && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("ant task calling its own parent target");
            }
            this.p1.executeTarget(this.target);
        }
        finally {
            Object var2_3 = null;
            this.p1 = null;
        }
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setAntfile(String s) {
        this.antFile = s;
    }

    public void setTarget(String s) {
        this.target = s;
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public Property createProperty() {
        if (this.p1 == null) {
            this.reinit();
        }
        Property p = (Property)this.p1.createTask("property");
        p.setUserProperty(true);
        this.properties.addElement(p);
        return p;
    }
}

