/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ejb.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import java.text.MessageFormat;
import java.util.ArrayList;
import xdoclet.DocletContext;
import xdoclet.DocletSupport;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.ejb.EntityCmpSubTask;
import xdoclet.ejb.tags.EjbTagsHandler;
import xdoclet.ejb.tags.EntityTagsHandler;
import xdoclet.ejb.tags.PersistentTagsHandler;
import xdoclet.tags.MethodTagsHandler;
import xdoclet.util.DocletUtil;

public class CmpTagsHandler
extends EntityTagsHandler {
    public static String getEntityCmpClassFor(ClassDoc clazz) throws XDocletException {
        String fileName = clazz.containingPackage().name();
        String entity_name = MessageFormat.format(CmpTagsHandler.getEntityCmpClassPattern(), EjbTagsHandler.getShortEjbNameFor(clazz));
        if ((fileName = EjbTagsHandler.choosePackage(fileName, null, "entitycmp")).length() > 0) {
            fileName = fileName + ".";
        }
        fileName = fileName + entity_name;
        return fileName;
    }

    public static boolean isEntityCmp(ClassDoc clazz) throws XDocletException {
        if (!EntityTagsHandler.isEntity(clazz)) {
            return false;
        }
        String bean_str = DocletUtil.getText((Doc)clazz, "ejb:bean");
        if (bean_str == null) {
            return true;
        }
        String value = XDocletTagSupport.getParameterValue(clazz, bean_str, "type", -1);
        if (value == null) {
            return true;
        }
        return value.equals("CMP");
    }

    public static boolean isUsingCmp2Impl(ClassDoc clazz) throws XDocletException {
        String bmp = XDocletTagSupport.getClassTagValue(clazz, "ejb:bean", "type", -1, "CMP,BMP", null, true, true);
        if (bmp != null && bmp.equalsIgnoreCase("BMP")) {
            return false;
        }
        boolean ejbspec2 = EjbTagsHandler.getEjbSpec().equals("2.0");
        if (!ejbspec2) {
            return false;
        }
        String cmp = XDocletTagSupport.getClassTagValue(clazz, "ejb:bean", "cmp-version", -1, EntityCmpSubTask.CmpSpecVersion.getVersions(), null, true, false);
        if (cmp == null) {
            EntityCmpSubTask entitycmp_subtask = (EntityCmpSubTask)DocletContext.getInstance().getSubTaskBy("entitycmp");
            cmp = entitycmp_subtask.getCmpSpec();
        }
        return "2.x".equals(cmp);
    }

    protected static String getEntityCmpClassPattern() {
        EntityCmpSubTask entitycmp_subtask = (EntityCmpSubTask)DocletContext.getInstance().getSubTaskBy("entitycmp");
        if (entitycmp_subtask != null) {
            return entitycmp_subtask.getEntityCmpClassPattern();
        }
        return "{0}CMP";
    }

    public String entityCmpClass() throws XDocletException {
        return CmpTagsHandler.getEntityCmpClassFor(XDocletTagSupport.getCurrentClass());
    }

    public void ifUsingCmp2(String template) throws XDocletException {
        if (CmpTagsHandler.isUsingCmp2Impl(XDocletTagSupport.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotUsingCmp2(String template) throws XDocletException {
        if (!CmpTagsHandler.isUsingCmp2Impl(XDocletTagSupport.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifEntityIsCmp(String template) throws XDocletException {
        if (CmpTagsHandler.isEntityCmp(XDocletTagSupport.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void forAllCmpEntityBeans(String template) throws XDocletException {
        ClassDoc[] classes = this.getContext().getRoot().classes();
        int i = 0;
        while (i < classes.length) {
            XDocletTagSupport.setCurrentClass(classes[i]);
            if (!DocletSupport.isDocletGenerated(XDocletTagSupport.getCurrentClass()) && CmpTagsHandler.isEntityCmp(XDocletTagSupport.getCurrentClass())) {
                this.generate(template);
            }
            ++i;
        }
    }

    public void forAllCmpFields(String template) throws XDocletException {
        if (CmpTagsHandler.isEntityCmp(XDocletTagSupport.getCurrentClass())) {
            ClassDoc oldClass = XDocletTagSupport.getCurrentClass();
            ArrayList<String> already = new ArrayList<String>();
            do {
                MethodDoc[] methods = XDocletTagSupport.getCurrentClass().methods();
                MethodDoc old_cur_method = XDocletTagSupport.getCurrentMethod();
                int j = 0;
                while (j < methods.length) {
                    MethodDoc current_method = methods[j];
                    if (!already.contains(current_method.name())) {
                        XDocletTagSupport.setCurrentMethod(current_method);
                        if (PersistentTagsHandler.isPersistentField(current_method) && MethodTagsHandler.isGetter(current_method.name())) {
                            this.generate(template);
                        }
                        already.add(current_method.name());
                    }
                    ++j;
                }
                XDocletTagSupport.setCurrentMethod(old_cur_method);
                XDocletTagSupport.pushCurrentClass(XDocletTagSupport.getCurrentClass().superclass());
            } while (XDocletTagSupport.getCurrentClass() != null);
            XDocletTagSupport.setCurrentClass(oldClass);
        }
    }
}

