/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.util;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.parameters.Parameterizable;

public final class ComponentStateValidator {
    private static final String OOO_FAIL = "Initialization out of order";
    private static final String LOG_FAIL = "Initialization out of order: LogEnabled";
    private static final String CONTEXT_FAIL = "Initialization out of order: Contextualizable";
    private static final String PARAMETER_FAIL = "Initialization out of order: Parameterizable";
    private static final String CONFIGURE_FAIL = "Initialization out of order: Configurable";
    private static final String COMPOSE_FAIL = "Initialization out of order: Composable";
    private static final String INIT_FAIL = "Initialization out of order: Initializable";
    private static final String START_FAIL = "Initialization out of order: Startable.start()";
    private static final String STOP_FAIL = "Initialization out of order: Startable.stop()";
    private static final String SUSPEND_FAIL = "Initialization out of order: Suspendable.suspend()";
    private static final String RESUME_FAIL = "Initialization out of order: Suspendable.resume()";
    private static final String DISPOSE_FAIL = "Initialization out of order: Disposable";
    private static final String ACTIVE_FAIL = "Component is not Active";
    private static final String WRITE_FAIL = "Value is already bound";
    private static final long LOG_ENABLED = 1L;
    private static final long CONTEXTUALIZED = 2L;
    private static final long PARAMETERIZED = 4L;
    private static final long CONFIGURED = 8L;
    private static final long COMPOSED = 16L;
    private static final long ACTIVE = 0x10000000L;
    private static final long INITIALIZED = 32L;
    private static final long STARTED = 64L;
    private static final long SUSPENDED = 0x1000000L;
    private static final long STOPPED = 128L;
    private static final long DISPOSED = 256L;
    private static final long INIT_MASK = 127L;
    private final long m_mask;
    private long m_state;

    public ComponentStateValidator(Object object) {
        int mask = 0;
        if (object instanceof LogEnabled || object instanceof Loggable) {
            mask = (int)((long)mask | 1L);
        }
        if (object instanceof Contextualizable) {
            mask = (int)((long)mask | 2L);
        }
        if (object instanceof Parameterizable) {
            mask = (int)((long)mask | 4L);
        }
        if (object instanceof Configurable) {
            mask = (int)((long)mask | 8L);
        }
        if (object instanceof Composable) {
            mask = (int)((long)mask | 0x10L);
        }
        if (object instanceof Initializable) {
            mask = (int)((long)mask | 0x20L);
        }
        if (object instanceof Disposable) {
            mask = (int)((long)mask | 0x100L);
        }
        if (object instanceof Startable) {
            mask = (int)((long)mask | 0xC0L);
        }
        if (object instanceof Suspendable) {
            mask = (int)((long)mask | 0x1000000L);
        }
        this.m_mask = (long)mask & 0xFFFFFFFFEFFFFFFFL;
    }

    public void checkLogEnabled() {
        this.checkLogEnabled(LOG_FAIL);
    }

    public void checkLogEnabled(String message) {
        if ((this.m_state & this.m_mask & 1L) > 0L || (this.m_mask & 1L) == 0L || this.m_state > 1L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 1L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkContextualized() {
        this.checkContextualized(CONTEXT_FAIL);
    }

    public void checkContextualized(String message) {
        if ((this.m_state & this.m_mask & 2L) > 0L || (this.m_mask & 2L) == 0L || this.m_state > 2L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 2L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkParameterized() {
        this.checkParameterized(PARAMETER_FAIL);
    }

    public void checkParameterized(String message) {
        if ((this.m_state & this.m_mask & 4L) > 0L || (this.m_mask & 4L) == 0L || this.m_state > 4L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 4L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkConfigured() {
        this.checkConfigured(CONFIGURE_FAIL);
    }

    public void checkConfigured(String message) {
        if ((this.m_state & this.m_mask & 8L) > 0L || (this.m_mask & 8L) == 0L || this.m_state > 8L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 8L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkComposed() {
        this.checkComposed(COMPOSE_FAIL);
    }

    public void checkComposed(String message) {
        if ((this.m_state & this.m_mask & 0x10L) > 0L || (this.m_mask & 0x10L) == 0L || this.m_state > 16L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 0x10L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkInitialized() {
        this.checkInitialized(INIT_FAIL);
    }

    public void checkInitialized(String message) {
        if ((this.m_state & this.m_mask & 0x20L) > 0L || (this.m_mask & 0x20L) == 0L || this.m_state > 32L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 0x20L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkStarted() {
        this.checkStarted(START_FAIL);
    }

    public void checkStarted(String message) {
        if ((this.m_state & this.m_mask & 0x40L) > 0L || (this.m_mask & 0x40L) == 0L || this.m_state > 64L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 0x40L;
        if ((this.m_state & 0x7FL) == (this.m_mask & 0x7FL)) {
            this.m_state |= 0x10000000L;
        }
    }

    public void checkSuspended() {
        this.checkSuspended(SUSPEND_FAIL);
    }

    public void checkSuspended(String message) {
        this.checkActive(message);
        if ((this.m_state & this.m_mask & 0x1000000L) > 0L || (this.m_mask & 0x1000000L) == 0L) {
            throw new IllegalStateException(message);
        }
        this.m_state |= 0x1000000L;
    }

    public void checkResumed() {
        this.checkResumed(RESUME_FAIL);
    }

    public void checkResumed(String message) {
        this.checkActive(message);
        if ((this.m_state & this.m_mask & 0x1000000L) == 0L || (this.m_mask & 0x1000000L) == 0L) {
            throw new IllegalStateException(message);
        }
        this.m_state &= 0xFFFFFFFFFEFFFFFFL;
    }

    public void checkStopped() {
        this.checkStopped(STOP_FAIL);
    }

    public void checkStopped(String message) {
        if ((this.m_state & this.m_mask & 0x80L) > 0L || (this.m_mask & 0x80L) == 0L || (this.m_state & this.m_mask) > 128L) {
            throw new IllegalStateException(message);
        }
        this.m_state &= 0xFFFFFFFFEFFFFFFFL;
        this.m_state |= 0x80L;
    }

    public void checkDisposed() {
        this.checkDisposed(DISPOSE_FAIL);
    }

    public void checkDisposed(String message) {
        if ((this.m_state & this.m_mask & 0x100L) > 0L || (this.m_mask & 0x100L) == 0L) {
            throw new IllegalStateException(message);
        }
        this.m_state &= 0xFFFFFFFFEFFFFFFFL;
        this.m_state |= 0x100L;
    }

    public void checkActive() {
        this.checkActive(ACTIVE_FAIL);
    }

    public void checkActive(String message) {
        if (this.isActive()) {
            return;
        }
        throw new IllegalStateException(message);
    }

    public boolean isActive() {
        return (0x10000000L & this.m_state) > 0L;
    }

    public void checkNotAssigned(Object object) {
        this.checkNotAssigned(object, WRITE_FAIL);
    }

    public void checkNotAssigned(Object object, String message) {
        if (null != object) {
            throw new IllegalStateException(message);
        }
    }
}

