/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.xml.EntityResolver;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class JaxpParser
extends AbstractLogEnabled
implements Parser,
ErrorHandler,
Composable,
Parameterizable,
Poolable {
    protected SAXParserFactory factory;
    protected DocumentBuilderFactory docFactory;
    protected XMLReader reader;
    protected DocumentBuilder docBuilder;
    protected ComponentManager manager;
    protected EntityResolver resolver;
    protected boolean nsPrefixes;
    protected boolean reuseParsers;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.manager.hasComponent("org.apache.avalon.excalibur.xml.EntityResolver")) {
            this.resolver = (EntityResolver)this.manager.lookup("org.apache.avalon.excalibur.xml.EntityResolver");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JaxpParser: Using EntityResolver: " + this.resolver);
            }
        }
    }

    public void parameterize(Parameters params) {
        boolean validate = params.getParameterAsBoolean("validate", false);
        this.nsPrefixes = params.getParameterAsBoolean("namespace-prefixes", false);
        this.reuseParsers = params.getParameterAsBoolean("reuse-parsers", true);
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(validate);
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docFactory.setValidating(validate);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JaxpParser: validating: " + validate + ", namespace-prefixes: " + this.nsPrefixes + ", reuse parser: " + this.reuseParsers);
        }
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        this.setupXMLReader();
        XMLReader tmpReader = this.reader;
        this.reader = null;
        try {
            if (consumer instanceof LexicalHandler) {
                tmpReader.setProperty("http://xml.org/sax/properties/lexical-handler", (LexicalHandler)((Object)consumer));
            }
        }
        catch (SAXException e) {
            this.getLogger().warn("SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        tmpReader.setErrorHandler(this);
        tmpReader.setContentHandler(consumer);
        if (null != this.resolver) {
            tmpReader.setEntityResolver(this.resolver);
        }
        tmpReader.parse(in);
        if (this.reuseParsers) {
            this.reader = tmpReader;
        }
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        this.setupDocumentBuilder();
        DocumentBuilder tmpBuilder = this.docBuilder;
        this.docBuilder = null;
        if (null != this.resolver) {
            tmpBuilder.setEntityResolver(this.resolver);
        }
        Document result = tmpBuilder.parse(input);
        if (this.reuseParsers) {
            this.docBuilder = tmpBuilder;
        }
        return result;
    }

    protected void setupXMLReader() throws SAXException {
        if (this.reader == null) {
            try {
                this.reader = this.factory.newSAXParser().getXMLReader();
                this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.nsPrefixes);
            }
            catch (Exception e) {
                this.getLogger().error("Cannot produce a valid parser", (Throwable)e);
                throw new SAXException("Cannot produce a valid parser", e);
            }
        }
    }

    protected void setupDocumentBuilder() {
        if (this.docBuilder == null) {
            try {
                this.docBuilder = this.docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                this.getLogger().error("Could not create DocumentBuilder", (Throwable)pce);
                throw new CascadingRuntimeException("Could not create DocumentBuilder", (Throwable)pce);
            }
        }
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException("Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }
}

