/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.utils.recycle;

import org.apache.avalon.utils.recycle.Controller;
import org.apache.avalon.utils.recycle.Recyclable;
import org.apache.avalon.utils.recycle.RecycleBin;
import org.apache.avalon.utils.recycle.RecycleBinIsFull;

public class ControlledContainer
implements RecycleBin {
    private RecycleBin container;
    private Controller controller;

    public Recyclable getRecyclable() {
        this.controller.down();
        return this.container.getRecyclable();
    }

    public void recycle(Recyclable object) {
        if (!this.controller.isThereRoomFor(object)) {
            try {
                object.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RecycleBinIsFull();
        }
        this.container.recycle(object);
        this.controller.up();
    }

    public int getSize() {
        return this.container.getSize();
    }

    public ControlledContainer(RecycleBin container, Controller controller) {
        this.container = container;
        this.controller = controller;
    }
}

