/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.avalon.CascadingThrowable;

public final class StringUtil {
    public static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static String printStackTrace(Throwable throwable) {
        return StringUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean printCascading) {
        return StringUtil.printStackTrace(throwable, 0, printCascading);
    }

    public static String printStackTrace(Throwable throwable, int depth) {
        String[] lines = StringUtil.captureStackTrace(throwable);
        if (depth == 0) {
            depth = lines.length;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append(lines[i]);
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable throwable, int depth, boolean printCascading) {
        String result = StringUtil.printStackTrace(throwable, depth);
        if (!printCascading || !(throwable instanceof CascadingThrowable)) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(result);
        throwable = ((CascadingThrowable)((Object)throwable)).getCause();
        while (throwable != null) {
            sb.append("rethrown from\n");
            sb.append(StringUtil.printStackTrace(throwable, depth));
            throwable = throwable instanceof CascadingThrowable ? ((CascadingThrowable)((Object)throwable)).getCause() : null;
        }
        return sb.toString();
    }

    protected static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return StringUtil.splitStackTrace(sw.getBuffer().toString());
    }

    protected static String[] splitStackTrace(String stackTrace) {
        StringTokenizer tokenizer = new StringTokenizer(stackTrace, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return lines.toArray(new String[0]);
    }

    private StringUtil() {
    }
}

