/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.output.DefaultOutputLogTarget;

public class Hierarchy {
    private static final Hierarchy c_hierarchy = new Hierarchy();
    private Logger m_rootLogger = new Logger(this, "", null, null);

    public static Hierarchy getDefaultHierarchy() {
        return c_hierarchy;
    }

    public void setDefaultLogTarget(LogTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Can not set DefaultLogTarget to null");
        }
        LogTarget[] targets = new LogTarget[]{target};
        this.getRootLogger().setLogTargets(targets);
    }

    public Logger getLoggerFor(String category) {
        return this.getRootLogger().getChildLogger(category);
    }

    public void log(String message, Throwable t) {
        System.err.println("Error: " + message);
        t.printStackTrace();
    }

    public void log(String message) {
        System.err.println("Error: " + message);
    }

    protected final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    public Hierarchy() {
        this.setDefaultLogTarget(new DefaultOutputLogTarget());
    }
}

