/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.io.FileTarget;

public final class FileTargetFactory
implements LogTargetFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        PatternFormatter formatter;
        ExtendedPatternFormatter extendedPatternFormatter;
        Configuration conf_filename = configuration.getChild("filename");
        String filename = this.processFilename(conf_filename.getValue());
        Configuration conf_format = configuration.getChild("format");
        String type = conf_format.getAttribute("type", "pattern");
        String format = conf_format.getValue(FORMAT);
        Configuration conf_append = configuration.getChild("append", false);
        boolean append = conf_append.getValueAsBoolean(false);
        if ("extended".equals(type)) {
            extendedPatternFormatter = new ExtendedPatternFormatter(format);
        } else if ("raw".equals(type)) {
            extendedPatternFormatter = new RawFormatter();
        } else {
            formatter = new PatternFormatter(format);
        }
        File file = new File(filename);
        FileTarget logtarget = null;
        try {
            logtarget = new FileTarget(file, append, (Formatter)formatter);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("cannot create FileTarget", (Throwable)ioe);
        }
        return logtarget;
    }

    private final String processFilename(String rawFilename) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = -1;
        while ((j = rawFilename.indexOf(123, i)) > -1) {
        }
        return rawFilename;
    }
}

