/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import xjavadoc.ClassIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.filesystem.FileSourceSet;

public class XJavadocFilter
extends BaseExtendSelector {
    XJavaDoc _xJavaDoc = new XJavaDoc();

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        if (!filename.endsWith(".java")) {
            return false;
        }
        this._xJavaDoc.reset(true);
        try {
            this._xJavaDoc.addSourceSet(new FileSourceSet(basedir, new String[]{filename}));
            ClassIterator i = XCollections.classIterator(this._xJavaDoc.getSourceClasses());
            while (i.hasNext()) {
                XClass clazz = i.next();
                Parameter[] params = this.getParameters();
                int j = 0;
                while (j < params.length) {
                    Parameter param = params[j];
                    if (param.getName().equals("implements")) {
                        String mandatoryClass = param.getValue();
                        if (!clazz.isA(mandatoryClass)) {
                            boolean bl = false;
                            return bl;
                        }
                    } else if (param.getName().equals("contains-tag")) {
                        String mandatoryTag = param.getValue();
                        if (!clazz.getDoc().hasTag(mandatoryTag)) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    ++j;
                }
            }
        }
        catch (OutOfMemoryError e) {
            System.err.println(e.getMessage());
            XJavaDoc.printMemoryStatus();
            System.err.println("Try to increase heap size. Can be done by defining ANT_OPTS=-Xmx640m");
            System.err.println("See the JDK tooldocs.");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException("Unexpected error", t);
        }
        finally {
            this._xJavaDoc.printLogMessages(System.out, 0);
            this._xJavaDoc.printLogMessages(System.out, 1);
            this._xJavaDoc.reset(true);
            System.gc();
        }
        return true;
    }
}

