/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ant.antunit.LogCapturer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.types.Resource;

public class LogContent
extends Resource {
    private LogLevel level;

    public LogContent() {
        this.setLevel(LogLevel.INFO);
    }

    public LogContent(Project p, LogLevel level) {
        this.setProject(p);
        this.setLevel(level);
    }

    public void setLevel(LogLevel level) {
        this.level = level;
        this.setName(level.getValue());
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        LogCapturer lc = this.getLogCapturer();
        if (lc != null) {
            return this.getLogStream(lc);
        }
        throw new IllegalStateException("antunit log unavailable");
    }

    public boolean isExists() {
        return this.getLogCapturer() != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogContent)) {
            return false;
        }
        LogContent olc = (LogContent)((Object)o);
        return olc.getProject() == this.getProject() && olc.level.getLevel() == this.level.getLevel();
    }

    private LogCapturer getLogCapturer() {
        Object o = this.getProject().getReference("ant.antunit.log");
        return o instanceof LogCapturer ? (LogCapturer)o : null;
    }

    private InputStream getLogStream(LogCapturer lc) {
        String log = null;
        switch (this.level.getLevel()) {
            case 0: {
                log = lc.getErrLog();
                break;
            }
            case 1: {
                log = lc.getWarnLog();
                break;
            }
            case 2: {
                log = lc.getInfoLog();
                break;
            }
            case 3: {
                log = lc.getVerboseLog();
                break;
            }
            case 4: {
                log = lc.getDebugLog();
                break;
            }
            default: {
                throw new IllegalStateException("how possible?");
            }
        }
        return new ByteArrayInputStream(log.getBytes());
    }
}

