/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class ExcaliburComponentSelector
extends AbstractLoggable
implements Contextualizable,
ComponentSelector,
Composable,
Configurable,
Initializable,
ThreadSafe,
Disposable,
RoleManageable,
LogKitManageable {
    private final ClassLoader m_loader;
    private static final String DEFAULT_NAME = "UnnamedSelector";
    private String m_rolename;
    protected Context m_context;
    private ComponentManager m_componentManager;
    private Map m_componentMapping;
    private Configuration m_configuration;
    private Map m_componentHandlers;
    private boolean m_disposed;
    private boolean m_initialized;
    private RoleManager m_roles;
    private LogKitManager m_logkit;

    public ExcaliburComponentSelector() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentSelector(ClassLoader loader) {
        this.m_loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        this.m_componentHandlers = Collections.synchronizedMap(new HashMap());
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }

    public void contextualize(Context context) {
        if (null == this.m_context) {
            this.m_context = context;
        }
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        if (null == this.m_componentManager) {
            this.m_componentManager = componentManager;
        }
    }

    public void initialize() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            this.m_initialized = true;
            ArrayList keys = new ArrayList(this.m_componentHandlers.keySet());
            int i = 0;
            while (i < keys.size()) {
                block6: {
                    Object key = keys.get(i);
                    ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                    try {
                        handler.initialize();
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isDebugEnabled()) break block6;
                        this.getLogger().debug("Caught an exception trying to initialize of the component handler.", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public boolean hasComponent(Object hint) {
        if (!this.m_initialized) {
            return false;
        }
        if (this.m_disposed) {
            return false;
        }
        boolean exists = false;
        try {
            this.release(this.select(hint));
            exists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exists;
    }

    public void dispose() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            Iterator<Object> keys = this.m_componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.m_componentHandlers.remove(keys.next());
            }
            keyList.clear();
            this.m_disposed = true;
        }
    }

    public Component select(Object hint) throws ComponentException {
        if (!this.m_initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized ComponentManager: " + hint);
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot select a Component from a disposed ComponentSelector");
        }
        if (null == hint) {
            String message = this.getName() + ": ComponentSelector Attempted to retrieve component with null hint.";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message);
            }
            throw new ComponentException(message);
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(hint));
        if (null == handler) {
            String message = this.getName() + ": ComponentSelector could not find the component for hint: " + hint;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ComponentException(message);
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (Exception e) {
            String message = this.getName() + ": ComponentSelector could not access the Component for hint: " + hint;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message, (Throwable)e);
            }
            throw new ComponentException(message, (Throwable)e);
        }
        if (null == component) {
            String message = this.getName() + ": ComponentSelector could not find the component for hint: " + hint;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ComponentException(message);
        }
        this.m_componentMapping.put(component, handler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String name;
        this.m_configuration = configuration;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentSelector setting up with root element: " + this.m_configuration.getName());
        }
        this.m_rolename = (name = configuration.getName()).equals("component") ? this.m_configuration.getAttribute("role") : this.m_roles.getRoleForName(name);
        Configuration[] instances = this.m_configuration.getChildren();
        int i = 0;
        while (i < instances.length) {
            String hint = instances[i].getAttribute("name").trim();
            String className = "component-instance".equals(instances[i].getName()) ? instances[i].getAttribute("class").trim() : this.m_roles.getDefaultClassNameForHint(this.m_rolename, instances[i].getName());
            try {
                Class<?> clazz = this.m_loader.loadClass(className);
                this.addComponent(hint, clazz, instances[i]);
            }
            catch (Exception e) {
                String message = "The component instance for '" + hint + "' has an invalid class name.";
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error(message, (Throwable)e);
                }
                throw new ConfigurationException(message, (Throwable)e);
            }
            ++i;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (null == this.m_roles) {
            this.m_roles = roles;
        }
    }

    public void setLogKitManager(LogKitManager logkit) {
        if (null == this.m_logkit) {
            this.m_logkit = logkit;
        }
    }

    public void release(Component component) {
        block4: {
            if (null == component) {
                return;
            }
            ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
            if (null == handler) {
                return;
            }
            try {
                handler.put(component);
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block4;
                this.getLogger().debug("Error trying to release component", (Throwable)e);
            }
        }
        this.m_componentMapping.remove(component);
    }

    public void addComponent(Object hint, Class component, Configuration configuration) throws ComponentException {
        if (this.m_initialized) {
            throw new ComponentException("Cannot add components to an initialized ComponentSelector", null);
        }
        try {
            ComponentHandler handler = ComponentHandler.getComponentHandler(component, configuration, this.m_componentManager, this.m_context, this.m_roles, this.m_logkit);
            handler.setLogger(this.getLogger());
            handler.initialize();
            this.m_componentHandlers.put(hint, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding " + component.getName() + " for " + hint.toString());
            }
        }
        catch (Exception e) {
            String message = "Could not set up Component for hint: " + hint;
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)e);
            }
            throw new ComponentException(message, (Throwable)e);
        }
    }

    public void addComponentInstance(Object hint, Component instance) {
        block4: {
            if (this.m_initialized) {
                throw new IllegalStateException("Cannot add components to an initialized ComponentSelector");
            }
            try {
                ComponentHandler handler = ComponentHandler.getComponentHandler(instance);
                handler.setLogger(this.getLogger());
                handler.initialize();
                this.m_componentHandlers.put(hint, handler);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Adding " + instance.getClass().getName() + " for " + hint.toString());
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("Could not set up Component for hint: " + hint, (Throwable)e);
            }
        }
    }

    private String getName() {
        if (null != this.m_configuration && !this.m_configuration.getName().equals("")) {
            return this.m_configuration.getName();
        }
        return DEFAULT_NAME;
    }
}

