/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyInterceptor;
import org.apache.tools.ant.TaskAdapter;
import org.xml.sax.Attributes;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PropertyHelper {
    Project project;
    Vector propertyInterceptors;

    public void setProject(Project p) {
        this.project = p;
    }

    public static PropertyHelper getPropertyHelper(Project project) {
        PropertyHelper ph = (PropertyHelper)project.getReference("ant.PropertyHelper");
        if (ph != null) {
            return ph;
        }
        ph = new PropertyHelper();
        ph.setProject(project);
        project.addReference("ant.PropertyHelper", (Object)ph);
        return ph;
    }

    public void addPropertyInterceptor(PropertyInterceptor pi) {
        this.propertyInterceptors.addElement(pi);
    }

    public String replaceProperties(String value) {
        if (value == null) {
            return null;
        }
        Vector fragments = new Vector();
        Vector propertyRefs = new Vector();
        ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Enumeration i = fragments.elements();
        Enumeration j = propertyRefs.elements();
        while (i.hasMoreElements()) {
            String fragment = (String)i.nextElement();
            if (fragment == null) {
                String propertyName = (String)j.nextElement();
                Object repl = this.processDynamic(this.project, propertyName);
                if (repl == null) {
                    repl = this.project.getProperty(propertyName);
                }
                if (repl == null) {
                    this.project.log("Property ${" + propertyName + "} has not been set", 3);
                    fragment = "${" + propertyName + '}';
                } else {
                    fragment = (String)repl;
                }
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    Object processDynamic(Project project, String name) {
        int i = 0;
        while (i < this.propertyInterceptors.size()) {
            PropertyInterceptor pi = (PropertyInterceptor)this.propertyInterceptors.elementAt(i);
            Object o = pi.getProperty(project, null, name);
            if (o != null) {
                return o;
            }
            ++i;
        }
        if (name.startsWith("toString:")) {
            Object v = project.getReference(name = name.substring("toString:".length()));
            if (v == null) {
                return null;
            }
            return v.toString();
        }
        return null;
    }

    public void configure(Object target, Attributes attrs, Project project) throws BuildException {
        if (target instanceof TaskAdapter) {
            target = ((TaskAdapter)target).getProxy();
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper(target.getClass());
        project.addBuildListener((BuildListener)ih);
        int i = 0;
        while (i < attrs.getLength()) {
            block4: {
                String value = this.replaceProperties(attrs.getValue(i));
                try {
                    ih.setAttribute(project, target, attrs.getQName(i).toLowerCase(Locale.US), value);
                }
                catch (BuildException be) {
                    if (attrs.getQName(i).equals("id")) break block4;
                    throw be;
                }
            }
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.propertyInterceptors = new Vector();
    }

    protected PropertyHelper() {
        this.this();
    }
}

