/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.pool;

import org.apache.avalon.Poolable;
import org.apache.avalon.Recyclable;
import org.apache.avalon.util.pool.ObjectFactory;
import org.apache.avalon.util.pool.Pool;
import org.apache.avalon.util.pool.PoolController;

public class AbstractPool
implements Pool {
    protected int m_count = 0;
    protected Poolable[] m_pool;
    protected ObjectFactory m_factory;
    protected PoolController m_controller;

    public Poolable get() throws Exception {
        int increase;
        if (this.m_count == 0 && this.m_controller != null && (increase = this.m_controller.grow()) > 0) {
            this.grow(increase);
        }
        if (this.m_count == 0) {
            return this.m_factory.newInstance();
        }
        --this.m_count;
        Poolable poolable = this.m_pool[this.m_count];
        this.m_pool[this.m_count] = null;
        return poolable;
    }

    public void put(Poolable poolable) {
        int decrease;
        if (poolable instanceof Recyclable) {
            ((Recyclable)poolable).recycle();
        }
        if (this.m_pool.length == this.m_count + 1 && this.m_controller != null && (decrease = this.m_controller.shrink()) > 0) {
            this.shrink(decrease);
        }
        if (this.m_pool.length > this.m_count + 1) {
            this.m_pool[this.m_count++] = poolable;
        }
    }

    public final int getCapacity() {
        return this.m_pool.length;
    }

    public final int getSize() {
        return this.m_count;
    }

    protected final void fill(int fillSize) throws Exception {
        int size = Math.min(this.m_pool.length, fillSize);
        int i = this.m_count;
        while (i < size) {
            this.m_pool[i] = this.m_factory.newInstance();
            ++i;
        }
        this.m_count = size;
    }

    public final void grow(int increase) {
        if (this.m_pool == null) {
            this.m_pool = new Poolable[increase];
            return;
        }
        Poolable[] poolables = new Poolable[increase + this.m_pool.length];
        System.arraycopy(this.m_pool, 0, poolables, 0, this.m_pool.length);
        this.m_pool = poolables;
    }

    public final void shrink(int decrease) {
        Poolable[] poolables = new Poolable[this.m_pool.length - decrease];
        System.arraycopy(this.m_pool, 0, poolables, 0, poolables.length);
        this.m_pool = poolables;
    }

    public AbstractPool(ObjectFactory factory, PoolController controller, int initial, int maximum) throws Exception {
        this.m_factory = factory;
        this.m_controller = controller;
        this.grow(maximum);
        this.fill(initial);
    }
}

