/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.util.ProxyClassLoader;
import org.apache.log.Logger;

public final class ProxyGenerator {
    protected static final boolean DEBUG = false;
    protected static final Logger LOGGER = null;
    protected static final Object MONITOR = new Object();
    protected static final ClassType BASE_CLASS = (ClassType)Type.getType((String)"java.lang.Object");
    protected static long c_currentId;

    protected static long getNextId() {
        Object object = MONITOR;
        synchronized (object) {
            long l = c_currentId++;
            Object var1_2 = null;
            return l;
        }
    }

    public static Object generateProxy(Object object, Class[] interfaces) throws IllegalArgumentException {
        int i = 0;
        while (i < interfaces.length) {
            if (!interfaces[i].isInterface()) {
                throw new IllegalArgumentException("Class " + interfaces[i].getName() + " is not an interface");
            }
            if (!interfaces[i].isInstance(object)) {
                throw new IllegalArgumentException("Object does not implement interface " + interfaces[i].getName());
            }
            ++i;
        }
        HashMap methodSet = ProxyGenerator.determineMethods(interfaces);
        String classname = "org.apache.avalon.tmp.Proxy" + ProxyGenerator.getNextId();
        ClassType proxy = ProxyGenerator.createProxyType(classname);
        ProxyGenerator.generateInterfaces(proxy, interfaces);
        ClassType target = (ClassType)Type.make(object.getClass());
        target.doFixups();
        ProxyGenerator.generateBase(proxy, (Type)target);
        Iterator methods = methodSet.values().iterator();
        while (methods.hasNext()) {
            ProxyGenerator.generateMethod(proxy, target, (java.lang.reflect.Method)methods.next());
        }
        proxy.doFixups();
        Class proxyClass = null;
        try {
            byte[] classData = proxy.writeToArray();
            ProxyClassLoader classLoader = new ProxyClassLoader(object.getClass().getClassLoader());
            proxyClass = classLoader.loadClass(classname, true, classData);
            Constructor ctor = proxyClass.getConstructor(object.getClass());
            return ctor.newInstance(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    protected static ClassType createProxyType(String classname) {
        ClassType proxy = new ClassType(classname);
        proxy.setModifiers(49);
        proxy.setSuper(BASE_CLASS);
        return proxy;
    }

    protected static void generateInterfaces(ClassType proxy, Class[] interfaces) {
        ClassType[] interfaceTypes = new ClassType[interfaces.length];
        int i = 0;
        while (i < interfaceTypes.length) {
            interfaceTypes[i] = (ClassType)Type.getType((String)interfaces[i].getName());
            ++i;
        }
        proxy.setInterfaces(interfaceTypes);
    }

    protected static void generateMethod(ClassType proxy, ClassType target, java.lang.reflect.Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        Type[] parameterTypes = new Type[parameters.length];
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = Type.getType((String)parameters[i].getName());
            ++i;
        }
        Type returnType = Type.getType((String)method.getReturnType().getName());
        Method newMethod = proxy.addMethod(method.getName(), 1, parameterTypes, returnType);
        newMethod.init_param_slots();
        newMethod.pushScope();
        CodeAttr code = newMethod.getCode();
        Field field = proxy.getField("m_core");
        code.emitPushThis();
        code.emitGetField(field);
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            code.emitLoad(code.getArg(1 + i2));
            ++i2;
        }
        Method targetMethod = target.getMethod(method.getName(), parameterTypes);
        code.emitInvokeVirtual(targetMethod);
        code.emitReturn();
        newMethod.popScope();
    }

    protected static void generateBase(ClassType proxy, Type target) {
        Field field = proxy.addField("m_core", target);
        field.flags |= 2;
        Method constructor = proxy.addMethod("<init>", 1, new Type[]{target}, (Type)Type.void_type);
        Method superConstructor = proxy.getSuperclass().addMethod("<init>", 1, null, (Type)Type.void_type);
        constructor.init_param_slots();
        constructor.pushScope();
        CodeAttr code = constructor.getCode();
        code.emitPushThis();
        code.emitInvokeSpecial(superConstructor);
        code.emitPushThis();
        code.emitLoad(code.getArg(1));
        code.emitPutField(field);
        code.emitReturn();
        constructor.popScope();
    }

    protected static HashMap determineMethods(Class[] interfaces) {
        HashMap<String, java.lang.reflect.Method> methodSet = new HashMap<String, java.lang.reflect.Method>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < interfaces.length) {
            java.lang.reflect.Method[] methods = interfaces[i].getMethods();
            int j = 0;
            while (j < methods.length) {
                sb.append(methods[j].getName());
                sb.append('(');
                Class<?>[] parameters = methods[j].getParameterTypes();
                int k = 0;
                while (k < parameters.length) {
                    sb.append(parameters[k].getName());
                    sb.append(' ');
                    ++k;
                }
                sb.append(";)");
                methodSet.put(sb.toString(), methods[j]);
                sb.setLength(0);
                ++j;
            }
            ++i;
        }
        return methodSet;
    }

    private ProxyGenerator() {
    }
}

