/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon;

import java.util.Iterator;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;

public abstract class AbstractConfiguration
implements Configuration {
    private static int PREFIX = 2;

    public int getValueAsInt() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(PREFIX), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(PREFIX), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(PREFIX), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as an integer");
        }
    }

    public int getValueAsInt(int defaultValue) {
        try {
            return this.getValueAsInt();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a long");
        }
    }

    public long getValueAsLong(long defaultValue) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        String value = this.getValue();
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a float");
        }
    }

    public float getValueAsFloat(float defaultValue) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        String value = this.getValue();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a boolean");
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getValue(String defaultValue) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public int getAttributeAsInt(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as an integer");
        }
    }

    public int getAttributeAsInt(String name, int defaultValue) {
        try {
            return this.getAttributeAsInt(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public long getAttributeAsLong(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a long");
        }
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        try {
            return this.getAttributeAsLong(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public float getAttributeAsFloat(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a float");
        }
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        try {
            return this.getAttributeAsFloat(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a boolean");
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.getAttribute(name);
        }
        catch (ConfigurationException ce) {
            return defaultValue;
        }
    }

    public Configuration getChild(String name) throws ConfigurationException {
        Iterator iterator = this.getChildren(name);
        if (iterator.hasNext()) {
            return (Configuration)iterator.next();
        }
        throw new ConfigurationException("No child name with name " + name);
    }

    public abstract String getName();

    public abstract String getLocation();

    public abstract Iterator getChildren(String var1);

    public abstract String getAttribute(String var1) throws ConfigurationException;

    public abstract String getValue() throws ConfigurationException;
}

