/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.ClassIterator;
import xjavadoc.TagIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.XTag;

public class EjbRefTagsHandler
extends EjbTagsHandler {
    protected transient String referringClassId;
    static /* synthetic */ Class class$xdoclet$modules$ejb$XDocletModulesEjbMessages;

    public String ejbRefId() throws XDocletException {
        return this.referringClassId + '_' + EjbTagsHandler.getEjbIdFor(XDocletTagSupport.getCurrentClass());
    }

    public void forAllEjbRefs(String template, Properties attributes) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)attributes.getProperty("superclasses"), (boolean)true);
        XClass oldCurClass = XDocletTagSupport.getCurrentClass();
        XClass currentClass = XDocletTagSupport.getCurrentClass();
        HashSet<String> already = new HashSet<String>();
        do {
            Collection tags = currentClass.getDoc().getTags("ejb.ejb-ref");
            TagIterator i = XCollections.tagIterator((Collection)tags);
            while (i.hasNext()) {
                XTag tag = i.next();
                XDocletTagSupport.setCurrentClassTag((XTag)tag);
                this.storeReferringClassId();
                String ejbName = XDocletTagSupport.getCurrentClassTag().getAttributeValue("ejb-name");
                String ejb_ref_signature = ejbName + "\u00a3" + XDocletTagSupport.getCurrentClassTag().getAttributeValue("view-type");
                if (!already.contains(ejb_ref_signature)) {
                    already.add(ejb_ref_signature);
                    XDocletTagSupport.pushCurrentClass((XClass)this.findEjb(ejbName));
                    this.generate(template);
                    XDocletTagSupport.popCurrentClass();
                }
                XDocletTagSupport.setCurrentClassTag(null);
                this.referringClassId = null;
            }
        } while (superclasses && (currentClass = currentClass.getSuperclass()) != null);
        XDocletTagSupport.setCurrentClass((XClass)oldCurClass);
    }

    public String ejbRefJndiName() throws XDocletException {
        String ejbRefJndiName = null;
        String jndiNameParameter = XDocletTagSupport.getCurrentClassTag().getAttributeValue("jndi-name");
        if (jndiNameParameter != null) {
            ejbRefJndiName = jndiNameParameter;
        } else {
            String refed_ejb_name = XDocletTagSupport.getCurrentClassTag().getAttributeValue("ejb-name");
            XClass refed_clazz = this.findEjb(refed_ejb_name);
            String ejb_type = EjbTagsHandler.isLocalEjb(refed_clazz) ? "local" : "remote";
            ejbRefJndiName = HomeTagsHandler.getJndiNameOfTypeFor(ejb_type, refed_clazz);
        }
        return this.prefixWithEjbSlash(ejbRefJndiName);
    }

    protected void storeReferringClassId() throws XDocletException {
        this.referringClassId = EjbTagsHandler.getEjbIdFor(XDocletTagSupport.getCurrentClass());
    }

    protected XClass findEjb(String ejbName) throws XDocletException {
        Collection classes = XJavaDoc.getInstance().getSourceClasses();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            if (!this.isEjb(clazz) || !ejbName.equals(EjbTagsHandler.getEjbNameFor(clazz))) continue;
            return clazz;
        }
        throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ejb$XDocletModulesEjbMessages == null ? (class$xdoclet$modules$ejb$XDocletModulesEjbMessages = EjbRefTagsHandler.class$("xdoclet.modules.ejb.XDocletModulesEjbMessages")) : class$xdoclet$modules$ejb$XDocletModulesEjbMessages), (String)"NOT_DEFINED", (String[])new String[]{ejbName}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

