/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.events.EventImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public abstract class NodeImpl
implements Node,
NodeList,
EventTarget,
Cloneable,
Serializable {
    static final long serialVersionUID = -6316591992167219696L;
    public static final short ELEMENT_DEFINITION_NODE = -1;
    protected NodeImpl ownerNode;
    protected short flags;
    protected static final short READONLY = 1;
    protected static final short SYNCDATA = 2;
    protected static final short SYNCCHILDREN = 4;
    protected static final short OWNED = 8;
    protected static final short FIRSTCHILD = 16;
    protected static final short SPECIFIED = 32;
    protected static final short IGNORABLEWS = 64;
    protected static final short SETVALUE = 128;
    protected static final boolean MUTATIONEVENTS = true;
    protected static final int MUTATION_NONE = 0;
    protected static final int MUTATION_LOCAL = 1;
    protected static final int MUTATION_AGGREGATE = 2;
    protected static final int MUTATION_ALL = 65535;

    public NodeImpl() {
    }

    protected NodeImpl(DocumentImpl documentImpl) {
        this.ownerNode = documentImpl;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl) {
        if (string == null || string.equals("") || eventListener == null) {
            return;
        }
        this.removeEventListener(string, eventListener, bl);
        Vector<LEntry> vector = this.ownerDocument().getEventListeners(this);
        if (vector == null) {
            vector = new Vector<LEntry>();
            this.ownerDocument().setEventListeners(this, vector);
        }
        vector.addElement(new LEntry(string, eventListener, bl));
        LCount lCount = LCount.lookup(string);
        if (bl) {
            ++lCount.captures;
        } else {
            ++lCount.bubbles;
        }
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    protected void changed() {
        this.ownerDocument().changed();
    }

    protected int changes() {
        return this.ownerDocument().changes();
    }

    public Node cloneNode(boolean bl) {
        NodeImpl nodeImpl;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            nodeImpl = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        nodeImpl.ownerNode = this.ownerDocument();
        nodeImpl.isOwned(false);
        nodeImpl.isReadOnly(false);
        return nodeImpl;
    }

    void dispatchAggregateEvents(AttrImpl attrImpl, String string) {
        if (this.ownerDocument().mutationEvents) {
            MutationEventImpl mutationEventImpl;
            LCount lCount;
            Vector vector = this.ownerDocument().getEventListeners(this);
            if (vector == null) {
                return;
            }
            NodeImpl nodeImpl = null;
            if (attrImpl != null) {
                lCount = LCount.lookup("DOMAttrModified");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0 && (nodeImpl = (NodeImpl)((Object)attrImpl.getOwnerElement())) != null) {
                    mutationEventImpl = new MutationEventImpl();
                    mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, null, string, attrImpl.getNodeValue(), attrImpl.getNodeName());
                    nodeImpl.dispatchEvent(mutationEventImpl);
                }
            }
            lCount = LCount.lookup("DOMSubtreeModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMSubtreeModified", true, false, null, null, null, null);
                if (attrImpl != null) {
                    attrImpl.dispatchEvent(mutationEventImpl);
                    if (nodeImpl != null) {
                        nodeImpl.dispatchEvent(mutationEventImpl);
                    }
                } else {
                    this.dispatchEvent(mutationEventImpl);
                }
            }
        }
    }

    void dispatchAggregateEvents(EnclosingAttr enclosingAttr) {
        if (enclosingAttr != null) {
            this.dispatchAggregateEvents(enclosingAttr.node, enclosingAttr.oldvalue);
        } else {
            this.dispatchAggregateEvents(null, null);
        }
    }

    public boolean dispatchEvent(Event event) {
        LEntry lEntry;
        int n;
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        if (event == null) {
            return false;
        }
        EventImpl eventImpl = (EventImpl)event;
        if (!eventImpl.initialized || eventImpl.type == null || eventImpl.type.equals("")) {
            throw new DOMExceptionImpl(100, "DOM010 Unspecified event type");
        }
        LCount lCount = LCount.lookup(eventImpl.getType());
        if (lCount.captures + lCount.bubbles + lCount.defaults == 0) {
            return eventImpl.preventDefault;
        }
        eventImpl.target = this;
        eventImpl.stopPropagation = false;
        eventImpl.preventDefault = false;
        Vector<Node> vector = new Vector<Node>(10, 10);
        Node node = this;
        Node node2 = node.getParentNode();
        while (node2 != null) {
            vector.addElement(node2);
            node = node2;
            node2 = node2.getParentNode();
        }
        if (lCount.captures > 0) {
            eventImpl.eventPhase = 1;
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                if (eventImpl.stopPropagation) break;
                cloneable2 = (NodeImpl)vector.elementAt(n2);
                eventImpl.currentNode = cloneable2;
                cloneable = this.ownerDocument().getEventListeners((NodeImpl)cloneable2);
                if (cloneable != null) {
                    object = (Vector)cloneable.clone();
                    n = ((Vector)object).size() - 1;
                    while (n >= 0) {
                        lEntry = (LEntry)((Vector)object).elementAt(n);
                        if (lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                            try {
                                lEntry.listener.handleEvent(eventImpl);
                            }
                            catch (Exception exception) {}
                        }
                        --n;
                    }
                }
                --n2;
            }
        }
        if (lCount.bubbles > 0) {
            eventImpl.eventPhase = (short)2;
            eventImpl.currentNode = this;
            Vector vector2 = this.ownerDocument().getEventListeners(this);
            if (!eventImpl.stopPropagation && vector2 != null) {
                cloneable2 = (Vector)vector2.clone();
                int n3 = ((Vector)cloneable2).size() - 1;
                while (n3 >= 0) {
                    object = (LEntry)((Vector)cloneable2).elementAt(n3);
                    if (object != null && !((LEntry)object).useCapture && ((LEntry)object).type.equals(eventImpl.type)) {
                        try {
                            ((LEntry)object).listener.handleEvent(eventImpl);
                        }
                        catch (Exception exception) {}
                    }
                    --n3;
                }
            }
            if (eventImpl.bubbles) {
                eventImpl.eventPhase = (short)3;
                int n4 = 0;
                while (n4 < vector.size()) {
                    if (eventImpl.stopPropagation) break;
                    cloneable = (NodeImpl)vector.elementAt(n4);
                    eventImpl.currentNode = cloneable;
                    vector2 = this.ownerDocument().getEventListeners((NodeImpl)cloneable);
                    if (vector2 != null) {
                        object = (Vector)vector2.clone();
                        n = ((Vector)object).size() - 1;
                        while (n >= 0) {
                            lEntry = (LEntry)((Vector)object).elementAt(n);
                            if (!lEntry.useCapture && lEntry.type.equals(eventImpl.type)) {
                                try {
                                    lEntry.listener.handleEvent(eventImpl);
                                }
                                catch (Exception exception) {}
                            }
                            --n;
                        }
                    }
                    ++n4;
                }
            }
        }
        boolean bl = lCount.defaults > 0 && (!eventImpl.cancelable || !eventImpl.preventDefault);
        return eventImpl.preventDefault;
    }

    void dispatchEventToSubtree(Node node, Event event) {
        if (this.ownerDocument().mutationEvents) {
            Vector vector = this.ownerDocument().getEventListeners(this);
            if (vector == null || node == null) {
                return;
            }
            ((NodeImpl)node).dispatchEvent(event);
            if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength() - 1;
                while (n >= 0) {
                    this.dispatchEventToSubtree(namedNodeMap.item(n), event);
                    --n;
                }
            }
            this.dispatchEventToSubtree(node.getFirstChild(), event);
            this.dispatchEventToSubtree(node.getNextSibling(), event);
        }
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    EnclosingAttr getEnclosingAttr() {
        if (this.ownerDocument().mutationEvents) {
            NodeImpl nodeImpl = this;
            while (true) {
                if (nodeImpl == null) {
                    return null;
                }
                short s = nodeImpl.getNodeType();
                if (s == 2) {
                    EnclosingAttr enclosingAttr = new EnclosingAttr();
                    enclosingAttr.node = (AttrImpl)nodeImpl;
                    enclosingAttr.oldvalue = enclosingAttr.node.getNodeValue();
                    return enclosingAttr;
                }
                if (s != 5) break;
                nodeImpl = nodeImpl.parentNode();
            }
            return null;
        }
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public String getNodeValue() {
        return null;
    }

    public Document getOwnerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (Document)((Object)this.ownerNode);
    }

    public Node getParentNode() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public boolean getReadOnly() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isReadOnly();
    }

    public Object getUserData() {
        return this.ownerDocument().getUserData(this);
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
    }

    final boolean internalIsIgnorableWhitespace() {
        return (this.flags & 0x40) != 0;
    }

    final boolean isFirstChild() {
        return (this.flags & 0x10) != 0;
    }

    final void isFirstChild(boolean bl) {
        this.flags = (short)(bl ? this.flags | 0x10 : this.flags & 0xFFFFFFEF);
    }

    final void isIgnorableWhitespace(boolean bl) {
        this.flags = (short)(bl ? this.flags | 0x40 : this.flags & 0xFFFFFFBF);
    }

    final boolean isOwned() {
        return (this.flags & 8) != 0;
    }

    final void isOwned(boolean bl) {
        this.flags = (short)(bl ? this.flags | 8 : this.flags & 0xFFFFFFF7);
    }

    final boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    final void isReadOnly(boolean bl) {
        this.flags = (short)(bl ? this.flags | 1 : this.flags & 0xFFFFFFFE);
    }

    final boolean isSpecified() {
        return (this.flags & 0x20) != 0;
    }

    final void isSpecified(boolean bl) {
        this.flags = (short)(bl ? this.flags | 0x20 : this.flags & 0xFFFFFFDF);
    }

    public Node item(int n) {
        return null;
    }

    final boolean needsSyncChildren() {
        return (this.flags & 4) != 0;
    }

    final void needsSyncChildren(boolean bl) {
        this.flags = (short)(bl ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final boolean needsSyncData() {
        return (this.flags & 2) != 0;
    }

    final void needsSyncData(boolean bl) {
        this.flags = (short)(bl ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    public void normalize() {
    }

    DocumentImpl ownerDocument() {
        if (this.isOwned()) {
            return this.ownerNode.ownerDocument();
        }
        return (DocumentImpl)this.ownerNode;
    }

    NodeImpl parentNode() {
        return null;
    }

    ChildNode previousSibling() {
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DOMExceptionImpl(8, "DOM008 Not found");
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl) {
        Vector vector = this.ownerDocument().getEventListeners(this);
        if (vector == null || string == null || string.equals("") || eventListener == null) {
            return;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            LEntry lEntry = (LEntry)vector.elementAt(n);
            if (lEntry.useCapture == bl && lEntry.listener == eventListener && lEntry.type.equals(string)) {
                vector.removeElementAt(n);
                if (vector.size() == 0) {
                    this.ownerDocument().setEventListeners(this, null);
                }
                LCount lCount = LCount.lookup(string);
                if (bl) {
                    --lCount.captures;
                    break;
                }
                --lCount.bubbles;
                break;
            }
            --n;
        }
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
    }

    public void setNodeValue(String string) throws DOMException {
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (!this.isOwned()) {
            this.ownerNode = documentImpl;
        }
    }

    public void setPrefix(String string) throws DOMException {
        throw new DOMExceptionImpl(14, "DOM003 Namespace error");
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isReadOnly(bl);
    }

    public void setUserData(Object object) {
        this.ownerDocument().setUserData(this, object);
    }

    final boolean setValueCalled() {
        return (this.flags & 0x80) != 0;
    }

    final void setValueCalled(boolean bl) {
        this.flags = (short)(bl ? this.flags | 0x80 : this.flags & 0xFFFFFF7F);
    }

    public boolean supports(String string, String string2) {
        return this.ownerDocument().getImplementation().hasFeature(string, string2);
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
    }

    public String toString() {
        return "[" + this.getNodeName() + ": " + this.getNodeValue() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        objectOutputStream.defaultWriteObject();
    }

    class LEntry {
        String type;
        EventListener listener;
        boolean useCapture;

        LEntry(String string, EventListener eventListener, boolean bl) {
            this.type = string;
            this.listener = eventListener;
            this.useCapture = bl;
        }
    }

    class EnclosingAttr {
        AttrImpl node;
        String oldvalue;

        EnclosingAttr() {
        }
    }
}

