/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;
import org.w3c.dom.Node;

public class TemplateList
implements Serializable {
    static boolean DEBUG = false;
    private Hashtable m_namedTemplates = new Hashtable(89);
    private Hashtable m_patternTable = new Hashtable(89);
    private TemplateSubPatternAssociation m_wildCardPatterns = null;
    private TemplateSubPatternAssociation m_textPatterns = null;
    private TemplateSubPatternAssociation m_docPatterns = null;
    private TemplateSubPatternAssociation m_commentPatterns = null;

    private void addObjectIfNotFound(Object object, Vector vector) {
        int n = vector.size();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (vector.elementAt(n2) == object) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            vector.addElement(object);
        }
    }

    private void checkConflicts(TemplateSubPatternAssociation templateSubPatternAssociation, XPathContext xPathContext, Node node, QName qName) {
    }

    public void compose() {
        if (DEBUG) {
            System.out.println("Before wildcard insert...");
            this.dumpAssociationTables();
        }
        if (this.m_wildCardPatterns != null) {
            Enumeration enumeration = this.m_patternTable.elements();
            while (enumeration.hasMoreElements()) {
                TemplateSubPatternAssociation templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
                TemplateSubPatternAssociation templateSubPatternAssociation2 = this.m_wildCardPatterns;
                while (templateSubPatternAssociation2 != null) {
                    try {
                        templateSubPatternAssociation = this.insertAssociationIntoList(templateSubPatternAssociation, (TemplateSubPatternAssociation)templateSubPatternAssociation2.clone(), true);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    templateSubPatternAssociation2 = templateSubPatternAssociation2.getNext();
                }
            }
        }
        if (DEBUG) {
            System.out.println("After wildcard insert...");
            this.dumpAssociationTables();
        }
    }

    void dumpAssociationTables() {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        Enumeration enumeration = this.m_patternTable.elements();
        while (enumeration.hasMoreElements()) {
            templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
            while (templateSubPatternAssociation != null) {
                System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
                templateSubPatternAssociation = templateSubPatternAssociation.getNext();
            }
            System.out.println("\n.....");
        }
        templateSubPatternAssociation = this.m_wildCardPatterns;
        System.out.print("wild card list: ");
        while (templateSubPatternAssociation != null) {
            System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
            templateSubPatternAssociation = templateSubPatternAssociation.getNext();
        }
        System.out.println("\n.....");
    }

    private TemplateSubPatternAssociation getHead(String string) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(string);
    }

    public TemplateSubPatternAssociation getHead(XPathContext xPathContext, Node node) {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 2: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(xPathContext.getDOMHelper().getLocalNameOfNode(node));
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(node.getNodeName());
                break;
            }
            case 7: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(xPathContext.getDOMHelper().getLocalNameOfNode(node));
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                templateSubPatternAssociation = this.m_docPatterns;
                break;
            }
            default: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(node.getNodeName());
            }
        }
        return templateSubPatternAssociation == null ? this.m_wildCardPatterns : templateSubPatternAssociation;
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation templateSubPatternAssociation) {
        StepPattern stepPattern;
        double d = templateSubPatternAssociation.getTemplate().getPriority();
        if (d == Double.NEGATIVE_INFINITY && (stepPattern = templateSubPatternAssociation.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)stepPattern).getDefaultScore();
        }
        return d;
    }

    public ElemTemplate getTemplate(QName qName) {
        return (ElemTemplate)this.m_namedTemplates.get(qName);
    }

    public ElemTemplate getTemplate(XPathContext xPathContext, Node node, QName qName, int n, boolean bl) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, node);
        if (templateSubPatternAssociation != null) {
            PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
            try {
                xPathContext.pushCurrentNodeAndExpression(node, node);
                do {
                    if (n > -1 && templateSubPatternAssociation.getImportLevel() > n) continue;
                    ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                    xPathContext.setNamespaceContext(elemTemplate);
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, node, qName);
                    }
                    ElemTemplate elemTemplate2 = elemTemplate;
                    Object var10_10 = null;
                    xPathContext.popCurrentNodeAndExpression();
                    xPathContext.setNamespaceContext(prefixResolver);
                    return elemTemplate2;
                } while ((templateSubPatternAssociation = templateSubPatternAssociation.getNext()) != null);
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                xPathContext.popCurrentNodeAndExpression();
                xPathContext.setNamespaceContext(prefixResolver);
                throw throwable;
            }
            Object var10_11 = null;
            xPathContext.popCurrentNodeAndExpression();
            xPathContext.setNamespaceContext(prefixResolver);
        }
        return null;
    }

    public TemplateWalker getWalker() {
        class Org_apache_xalan_templates_TemplateList$1 {
            /* synthetic */ Org_apache_xalan_templates_TemplateList$1() {
            }
        }
        return new TemplateWalker();
    }

    private TemplateSubPatternAssociation insertAssociationIntoList(TemplateSubPatternAssociation templateSubPatternAssociation, TemplateSubPatternAssociation templateSubPatternAssociation2, boolean bl) {
        boolean bl2;
        double d;
        TemplateSubPatternAssociation templateSubPatternAssociation3;
        double d2 = this.getPriorityOrScore(templateSubPatternAssociation2);
        int n = templateSubPatternAssociation2.getImportLevel();
        int n2 = templateSubPatternAssociation2.getDocOrderPos();
        TemplateSubPatternAssociation templateSubPatternAssociation4 = templateSubPatternAssociation;
        while ((templateSubPatternAssociation3 = templateSubPatternAssociation4.getNext()) != null) {
            d = this.getPriorityOrScore(templateSubPatternAssociation3);
            if (n > templateSubPatternAssociation3.getImportLevel()) break;
            if (n < templateSubPatternAssociation3.getImportLevel()) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (d2 > d) break;
            if (d2 < d) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (n2 >= templateSubPatternAssociation3.getDocOrderPos()) break;
            templateSubPatternAssociation4 = templateSubPatternAssociation3;
        }
        if (templateSubPatternAssociation3 == null || templateSubPatternAssociation4 == templateSubPatternAssociation) {
            d = this.getPriorityOrScore(templateSubPatternAssociation4);
            bl2 = n > templateSubPatternAssociation4.getImportLevel() ? true : (n < templateSubPatternAssociation4.getImportLevel() ? false : (d2 > d ? true : (d2 < d ? false : n2 >= templateSubPatternAssociation4.getDocOrderPos())));
        } else {
            bl2 = false;
        }
        if (bl) {
            if (bl2) {
                templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
                String string = templateSubPatternAssociation4.getTargetString();
                templateSubPatternAssociation2.setTargetString(string);
                this.putHead(string, templateSubPatternAssociation2);
                return templateSubPatternAssociation2;
            }
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
            templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
            return templateSubPatternAssociation;
        }
        if (bl2) {
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
            if (templateSubPatternAssociation4.isWild() || templateSubPatternAssociation2.isWild()) {
                this.m_wildCardPatterns = templateSubPatternAssociation2;
            } else {
                this.putHead(templateSubPatternAssociation2.getTargetString(), templateSubPatternAssociation2);
            }
            return templateSubPatternAssociation2;
        }
        templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
        templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
        return templateSubPatternAssociation;
    }

    private void insertPatternInTable(StepPattern stepPattern, ElemTemplate elemTemplate) {
        String string = stepPattern.getTargetString();
        if (string != null) {
            TemplateSubPatternAssociation templateSubPatternAssociation;
            String string2 = elemTemplate.getMatch().getPatternString();
            TemplateSubPatternAssociation templateSubPatternAssociation2 = new TemplateSubPatternAssociation(elemTemplate, stepPattern, string2);
            boolean bl = templateSubPatternAssociation2.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation3 = templateSubPatternAssociation = bl ? this.m_wildCardPatterns : this.getHead(string);
            if (templateSubPatternAssociation == null) {
                if (bl) {
                    this.m_wildCardPatterns = templateSubPatternAssociation2;
                } else {
                    this.putHead(string, templateSubPatternAssociation2);
                }
            } else {
                this.insertAssociationIntoList(templateSubPatternAssociation, templateSubPatternAssociation2, false);
            }
        }
    }

    private void putHead(String string, TemplateSubPatternAssociation templateSubPatternAssociation) {
        if (string.equals("#text")) {
            this.m_textPatterns = templateSubPatternAssociation;
        } else if (string.equals("/")) {
            this.m_docPatterns = templateSubPatternAssociation;
        } else if (string.equals("#comment")) {
            this.m_commentPatterns = templateSubPatternAssociation;
        }
        this.m_patternTable.put(string, templateSubPatternAssociation);
    }

    private void setNamedTemplates(Hashtable hashtable) {
        this.m_namedTemplates = hashtable;
    }

    public void setTemplate(ElemTemplate elemTemplate) {
        Serializable serializable;
        if (elemTemplate.getName() != null) {
            serializable = (ElemTemplate)this.m_namedTemplates.get(elemTemplate.getName());
            if (serializable == null) {
                this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
            } else {
                int n = ((ElemTemplate)serializable).getStylesheetComposed().getImportCountComposed();
                int n2 = elemTemplate.getStylesheetComposed().getImportCountComposed();
                if (n2 > n) {
                    this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
                } else if (n2 == n) {
                    elemTemplate.error(105, new Object[]{elemTemplate.getName()});
                }
            }
        }
        if ((serializable = elemTemplate.getMatch()) != null) {
            Expression expression = ((XPath)serializable).getExpression();
            if (expression instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)expression, elemTemplate);
            } else if (expression instanceof UnionPattern) {
                UnionPattern unionPattern = (UnionPattern)expression;
                StepPattern[] stepPatternArray = unionPattern.getPatterns();
                int n = stepPatternArray.length;
                int n3 = 0;
                while (n3 < n) {
                    this.insertPatternInTable(stepPatternArray[n3], elemTemplate);
                    ++n3;
                }
            }
        }
    }

    public class TemplateWalker {
        private Enumeration hashIterator;
        private boolean inPatterns;
        private TemplateSubPatternAssociation curPattern;
        private Hashtable m_compilerCache = new Hashtable();

        private TemplateWalker() {
            this.hashIterator = TemplateList.this.m_patternTable.elements();
            this.inPatterns = true;
            this.curPattern = null;
        }

        public ElemTemplate next() {
            ElemTemplate elemTemplate;
            ElemTemplateElement elemTemplateElement = null;
            do {
                if (this.inPatterns) {
                    if (this.curPattern != null) {
                        this.curPattern = this.curPattern.getNext();
                    }
                    if (this.curPattern != null) {
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else if (this.hashIterator.hasMoreElements()) {
                        this.curPattern = (TemplateSubPatternAssociation)this.hashIterator.nextElement();
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else {
                        this.inPatterns = false;
                        this.hashIterator = TemplateList.this.m_namedTemplates.elements();
                    }
                }
                if (this.inPatterns) continue;
                if (this.hashIterator.hasMoreElements()) {
                    elemTemplateElement = (ElemTemplate)this.hashIterator.nextElement();
                    continue;
                }
                return null;
            } while ((elemTemplate = (ElemTemplate)this.m_compilerCache.get(new Integer(elemTemplateElement.getUid()))) != null);
            this.m_compilerCache.put(new Integer(elemTemplateElement.getUid()), elemTemplateElement);
            return elemTemplateElement;
        }
    }
}

