/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

public class Priority {
    int level;
    String levelStr;
    int syslogEquivalent;
    public static final int FATAL_INT = 50000;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final Priority FATAL = new Priority(50000, "FATAL", 0);
    public static final Priority ERROR = new Priority(40000, "ERROR", 3);
    public static final Priority WARN = new Priority(30000, "WARN", 4);
    public static final Priority INFO = new Priority(20000, "INFO", 6);
    public static final Priority DEBUG = new Priority(10000, "DEBUG", 7);

    protected Priority(int level, String levelStr, int syslogEquivalent) {
        this.level = level;
        this.levelStr = levelStr;
        this.syslogEquivalent = syslogEquivalent;
    }

    public final int getSyslogEquivalent() {
        return this.syslogEquivalent;
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.level;
    }

    public boolean isGreaterOrEqual(Priority r) {
        return this.level >= r.level;
    }

    public static Priority[] getAllPossiblePriorities() {
        return new Priority[]{FATAL, ERROR, WARN, INFO, DEBUG};
    }

    public static Priority toPriority(String sArg) {
        return Priority.toPriority(sArg, DEBUG);
    }

    public static Priority toPriority(int val) {
        return Priority.toPriority(val, DEBUG);
    }

    public static Priority toPriority(int val, Priority defaultPriority) {
        switch (val) {
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
        }
        return defaultPriority;
    }

    public static Priority toPriority(String sArg, Priority defaultPriority) {
        if (sArg == null) {
            return defaultPriority;
        }
        String s = sArg.toUpperCase();
        if (s.equals("DEBUG")) {
            return DEBUG;
        }
        if (s.equals("INFO")) {
            return INFO;
        }
        if (s.equals("WARN")) {
            return WARN;
        }
        if (s.equals("ERROR")) {
            return ERROR;
        }
        if (s.equals("FATAL")) {
            return FATAL;
        }
        return defaultPriority;
    }
}

