/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class Zip
extends MatchingTask {
    private File zipFile;
    private File baseDir;
    private boolean doCompress = true;
    protected String archiveType = "zip";
    private static long emptyCrc = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    private Hashtable addedDirs = new Hashtable();

    protected void addFiles(FileScanner scanner, ZipOutputStream zOut, String prefix) throws IOException {
        File thisBaseDir = scanner.getBasedir();
        String[] dirs = scanner.getIncludedDirectories();
        int i = 0;
        while (i < dirs.length) {
            String name = dirs[i].replace(File.separatorChar, '/');
            if (!name.endsWith("/")) {
                name = String.valueOf(name) + "/";
            }
            this.addParentDirs(thisBaseDir, name, zOut, prefix);
            ++i;
        }
        String[] files = scanner.getIncludedFiles();
        int i2 = 0;
        while (i2 < files.length) {
            File f = new File(thisBaseDir, files[i2]);
            String name = files[i2].replace(File.separatorChar, '/');
            this.addParentDirs(thisBaseDir, name, zOut, prefix);
            this.zipFile(f, zOut, String.valueOf(prefix) + name);
            ++i2;
        }
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix) throws IOException {
        String dir;
        Stack<String> directories = new Stack<String>();
        int slashPos = entry.length();
        while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
            dir = entry.substring(0, slashPos + 1);
            if (this.addedDirs.get(String.valueOf(prefix) + dir) != null) break;
            directories.push(dir);
        }
        while (!directories.isEmpty()) {
            dir = (String)directories.pop();
            File f = new File(baseDir, dir);
            this.zipDir(f, zOut, String.valueOf(prefix) + dir);
        }
    }

    public void execute() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one fileset must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        Vector<DirectoryScanner> dss = new Vector<DirectoryScanner>();
        if (this.baseDir != null) {
            dss.addElement(this.getDirectoryScanner(this.baseDir));
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            dss.addElement(fs.getDirectoryScanner(this.project));
            ++i;
        }
        Object[] scanners = new FileScanner[dss.size()];
        dss.copyInto(scanners);
        if (this.isUpToDate((FileScanner[])scanners, this.zipFile)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        try {
            ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(this.zipFile));
            try {
                if (this.doCompress) {
                    zOut.setMethod(8);
                } else {
                    zOut.setMethod(0);
                }
                this.initZipOutputStream(zOut);
                int j = 0;
                while (j < scanners.length) {
                    this.addFiles((FileScanner)scanners[j], zOut, "");
                    ++j;
                }
            }
            finally {
                Object var6_7 = null;
                zOut.close();
            }
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
            if (!this.zipFile.delete()) {
                msg = String.valueOf(msg) + " (and the archive is probably corrupt but I could not delete it)";
            }
            throw new BuildException(msg, ioe, this.location);
        }
    }

    protected static File[] grabFiles(FileScanner[] scanners) {
        Vector<File> files = new Vector<File>();
        int i = 0;
        while (i < scanners.length) {
            File thisBaseDir = scanners[i].getBasedir();
            String[] ifiles = scanners[i].getIncludedFiles();
            int j = 0;
            while (j < ifiles.length) {
                files.addElement(new File(thisBaseDir, ifiles[j]));
                ++j;
            }
            ++i;
        }
        Object[] toret = new File[files.size()];
        files.copyInto(toret);
        return toret;
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        File[] files = Zip.grabFiles(scanners);
        if (files.length == 0) {
            if (this.emptyBehavior.equals("skip")) {
                this.log("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                return true;
            }
            if (this.emptyBehavior.equals("fail")) {
                throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.location);
            }
            if (zipFile.exists()) {
                return true;
            }
            this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
            try {
                FileOutputStream os = new FileOutputStream(zipFile);
                try {
                    byte[] empty = new byte[22];
                    empty[0] = 80;
                    empty[1] = 75;
                    empty[2] = 5;
                    empty[3] = 6;
                    ((OutputStream)os).write(empty);
                }
                finally {
                    Object var6_8 = null;
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create empty ZIP archive", ioe, this.location);
            }
            return true;
        }
        if (!zipFile.exists()) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].lastModified() > zipFile.lastModified()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setBasedir(String baseDirname) {
        this.baseDir = this.project.resolveFile(baseDirname);
    }

    public void setCompress(String compress) {
        this.doCompress = Project.toBoolean(compress);
    }

    public void setWhenempty(String we) throws BuildException {
        if (!("fail".equals(we = we.toLowerCase()) || "skip".equals(we) || "create".equals(we))) {
            throw new BuildException("Unrecognized whenempty attribute: " + we);
        }
        this.emptyBehavior = we;
    }

    public void setZipfile(File zipFile) {
        this.zipFile = zipFile;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.addedDirs.put(vPath, vPath);
        ZipEntry ze = new ZipEntry(vPath);
        if (dir != null) {
            ze.setTime(dir.lastModified());
        }
        ze.setSize(0L);
        ze.setMethod(0);
        ze.setCrc(emptyCrc);
        zOut.putNextEntry(ze);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified());
        }
        finally {
            Object var6_5 = null;
            fIn.close();
        }
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified) throws IOException {
        ZipEntry ze = new ZipEntry(vPath);
        ze.setTime(lastModified);
        if (!this.doCompress) {
            long size = 0L;
            CRC32 cal = new CRC32();
            if (!in.markSupported()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                    bos.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in = new ByteArrayInputStream(bos.toByteArray());
            } else {
                in.mark(Integer.MAX_VALUE);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    size += (long)count;
                    cal.update(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.reset();
            }
            ze.setSize(size);
            ze.setCrc(cal.getValue());
        }
        zOut.putNextEntry(ze);
        byte[] buffer = new byte[8192];
        int count = 0;
        do {
            zOut.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
    }
}

