/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.pipeline;

import org.apache.avalon.DefaultPipeline;
import org.apache.avalon.Loggable;
import org.apache.avalon.Stage;
import org.apache.avalon.camelot.AvalonEntry;
import org.apache.avalon.util.pipeline.AvalonStage;
import org.apache.log.Logger;

public class AvalonPipeline
extends DefaultPipeline
implements AvalonStage,
Loggable {
    protected boolean m_consumeException;
    protected Logger m_logger;

    public void setLogger(Logger logger) {
        this.m_logger = logger;
        int n = this.m_stages.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.m_stages.get(n2);
            if (e instanceof Loggable) {
                ((Loggable)e).setLogger(this.m_logger);
            }
            ++n2;
        }
    }

    public void setConsumeException(boolean bl) {
        this.m_consumeException = bl;
    }

    public void addStage(Stage stage) {
        super.addStage(stage);
        if (stage instanceof Loggable) {
            ((Loggable)((Object)stage)).setLogger(this.m_logger);
        }
    }

    public void process(String string, AvalonEntry avalonEntry) throws Exception {
        int n = this.m_stages.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                AvalonStage avalonStage = (AvalonStage)this.m_stages.get(n2);
                avalonStage.process(string, avalonEntry);
            }
            catch (Exception exception) {
                if (this.m_consumeException) {
                    this.m_logger.warn("Error processing " + string, exception);
                }
                throw exception;
            }
            ++n2;
        }
    }
}

