/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.filter;

import org.apache.log.FilterTarget;
import org.apache.log.LogEntry;
import org.apache.log.LogTarget;

public abstract class AbstractFilterTarget
implements FilterTarget {
    protected LogTarget[] m_targets;

    public void addTarget(LogTarget logTarget) {
        if (null == this.m_targets) {
            this.m_targets = new LogTarget[]{logTarget};
        } else {
            LogTarget[] logTargetArray = this.m_targets;
            this.m_targets = new LogTarget[logTargetArray.length + 1];
            System.arraycopy(logTargetArray, 0, this.m_targets, 0, logTargetArray.length);
            this.m_targets[this.m_targets.length - 1] = logTarget;
        }
    }

    protected abstract boolean filter(LogEntry var1);

    public void processEntry(LogEntry logEntry) {
        if (null == this.m_targets || this.filter(logEntry)) {
            return;
        }
        int n = 0;
        while (n < this.m_targets.length) {
            this.m_targets[n].processEntry(logEntry);
            ++n;
        }
    }
}

